// SWIG file NumericalPoint.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-29 08:12:01 +0200 (Fri, 29 Jul 2011) $
// Id : $Id: NumericalPoint.i 2051 2011-07-29 06:12:01Z schueller $

%{
#include "NumericalPoint.hxx"
%}

//%rename(NumericalPoint_operator___eq__)        OpenTURNS::Base::Type::operator ==(const NumericalPoint & lhs, const NumericalPoint & rhs);
%template(NumericalScalarCollection)           OpenTURNS::Base::Type::Collection<OpenTURNS::NumericalScalar>;
%template(NumericalScalarPersistentCollection) OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::NumericalScalar>;
%template(NumericalPointCollection)            OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Type::NumericalPoint>;
%template(NumericalPointPersistentCollection)  OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Base::Type::NumericalPoint>;

%typemap(in) const NumericalPoint & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    temp = OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPoint>( $input );
    $1 = &temp;
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const NumericalPoint & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) ||
       OpenTURNS::isAPythonSequenceOf<OpenTURNS::_PyFloat_>( $input );
}

%apply const NumericalPoint & { const Type::NumericalPoint &, const Base::Type::NumericalPoint &, const OpenTURNS::Base::Type::NumericalPoint & };

%include NumericalPoint.hxx
%copyctor NumericalPoint;

namespace OpenTURNS{ namespace Base { namespace Type {

%extend NumericalPoint {

NumericalPoint(PyObject * pyObj)
{
 return new OpenTURNS::Base::Type::NumericalPoint( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPoint>(pyObj) );
}

Bool __eq__(const NumericalPoint & other)
{
 return operator == (*self, other);
}

/* NumericalPoint __add__(const NumericalPoint & other) */
/* { */
/*  return *self + other; */
/* } */

NumericalPoint operator +(const NumericalPoint & other)
{
 return *self + other;
}

NumericalPoint __sub__(const NumericalPoint & other)
{
 return *self - other;
}

NumericalPoint __mul__(NumericalScalar s)
{
 return *self * s;
}

NumericalPoint __iadd__(const NumericalPoint & other)
{
 *self += other;
 return *self;
}

NumericalPoint __isub__(const NumericalPoint & other)
{
 *self -= other;
 return *self;
}

} // %extend

}}}
