// SWIG file Distribution.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-06 12:03:57 +0200 (Wed, 06 Jul 2011) $
// Id : $Id: Distribution.i 1991 2011-07-06 10:03:57Z schueller $

%{
#include "Distribution.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Model::Distribution>
  {
    typedef _PyObject_ Type;
  };


  template <>
  inline
  OpenTURNS::Uncertainty::Model::Distribution
  convert<_PyObject_,OpenTURNS::Uncertainty::Model::Distribution>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (! SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::DistributionImplementation *"), 0 |  0 )))
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is not an object convertible to an DistributionImplementation";
    OpenTURNS::Uncertainty::Model::DistributionImplementation * p_di = reinterpret_cast< OpenTURNS::Uncertainty::Model::DistributionImplementation * >( ptr );
    return *p_di;
  }

} /* namespace OpenTURNS */


%}

%template(DistributionImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Uncertainty::Model::DistributionImplementation>;

%typemap(in) const Distribution & ($1_basetype temp) {
  if (! SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &$1, $1_descriptor, 0))) {
    OpenTURNS::Uncertainty::Model::DistributionImplementation * p_impl = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr($input, (void **) &p_impl, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::DistributionImplementation *"), 0))) {
      temp = OpenTURNS::Uncertainty::Model::Distribution( *p_impl );
      $1 = &temp;
    } else throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object is not convertible to a distribution";
  }
}

%typemap(typecheck,precedence=SWIG_TYPECHECK_POINTER) const Distribution & {
  $1 = SWIG_IsOK(SWIG_ConvertPtr($input, NULL, $1_descriptor, 0)) || SWIG_IsOK(SWIG_ConvertPtr($input, NULL, SWIG_TypeQuery("OpenTURNS::Uncertainty::Model::DistributionImplementation *"), 0));
}

%apply const Distribution & { const Model::Distribution &, const Uncertainty::Model::Distribution &, const OpenTURNS::Uncertainty::Model::Distribution & };

%include Distribution.hxx
//%copyctor Distribution;

namespace OpenTURNS { namespace Uncertainty { namespace Model {

%extend Distribution {

Distribution(const Distribution & other) { return new OpenTURNS::Uncertainty::Model::Distribution(other); }

}
}}}
