#                                               -*- Autoconf -*-
#
#  ot_debug.m4
#
#  (C) Copyright 2005-2011 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: schueller $
#  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
#  Id:      $Id: ot_debug.m4 1866 2011-04-11 10:32:27Z schueller $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether debug statements should be included
#
# OT_DEBUG( level )
# -----------------
#
AC_DEFUN([OT_DEBUG],
[
  AC_ARG_ENABLE([debug],
                AC_HELP_STRING([--enable-debug@<:@=taglist@:>@], [Add debug information.
	                       Debugging can be specified as a comma separated tag list where tags can be: message, memory, boundchecking, assert, saveloadchecking, slowfs. Default is boundchecking, saveloadchecking and assert.]),
			       [test x$enableval = xyes && enableval="message,boundchecking,assert,saveloadchecking"], [enableval="boundchecking,assert,saveloadchecking"])

  test x$enableval = xno && enableval="none"

  # default is NOT to produce assertions
  ASSERTFLAGS="-DNDEBUG"

  OT_CPPFLAGS=""
  OT_CFLAGS=""
  OT_FFLAGS=""
  OT_CXXFLAGS=""
  OT_LDFLAGS=""
  OT_LIBADD=""
  OT_LDADD=""

  for flag in `echo $enableval| tr "," " "`
  do
    case $flag in
    message)
      OT_CPPFLAGS="$OT_CPPFLAGS -DDEBUG"
      OT_CFLAGS="$OT_CFLAGS -g"
      OT_FFLAGS="$OT_FFLAGS -g"
      OT_CXXFLAGS="$OT_CXXFLAGS -g"
      ;;

    memory)
      OT_CPPFLAGS="$OT_CPPFLAGS -DDEBUG_MEMORY"
      ;;

    boundchecking)
      OT_CPPFLAGS="$OT_CPPFLAGS -DDEBUG_BOUNDCHECKING"
      ;;

    assert)
      ASSERTFLAGS=
      ;;

    saveloadchecking)
      OT_CPPFLAGS="$OT_CPPFLAGS -DSAVELOAD_CHECKING"
      ;;

    slowfs)
      OT_CPPFLAGS="$OT_CPPFLAGS -DSLOW_FILESYSTEM"
      ;;

    none)
      ;;

    *)
      AC_MSG_ERROR([Debug option : invalid argument ($flag).])
      ;;
    esac
  done

  DEBUG_LEVEL=$enableval

  OT_CPPFLAGS="$OT_CPPFLAGS $ASSERTFLAGS"
  OT_CFLAGS="$OT_CFLAGS $ASSERTFLAGS"
  OT_FFLAGS="$OT_FFLAGS $ASSERTFLAGS"
  OT_CXXFLAGS="$OT_CXXFLAGS $ASSERTFLAGS"

  AC_SUBST(OT_CPPFLAGS)
  AC_SUBST(OT_CFLAGS)
  AC_SUBST(OT_FFLAGS)
  AC_SUBST(OT_CXXFLAGS)
  AC_SUBST(OT_LDFLAGS)
  AC_SUBST(OT_LIBADD)
  AC_SUBST(OT_LDADD)

  AC_MSG_NOTICE([Debug level is $enableval])
])
