//                                               -*- C++ -*-
/**
 *  @file  t_KFold_std.cxx
 *  @brief The test file of class KFold for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (Thu, 04 Feb 2010) $
 *  Id:      $Id: t_KFold_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;
using namespace OT::Base::Algo;
using namespace OT::Base::Func;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  const UnsignedLong size = 100;
  Uniform xuniform(0.9, 1.1);
  NumericalSample x( xuniform.getNumericalSample(size) );
  Uniform yuniform(1.9, 2.1);
  NumericalSample y( yuniform.getNumericalSample(size) );
  NumericalMathFunction f( Description("x"),Description("y"), Description("2.0*x") );
  Basis basis;
  basis.add(f);

  FittingAlgorithm fittingAlgo = KFold();

  NumericalScalar result = fittingAlgo.run( x, y, basis );

  fullprint << "result = " << result << std::endl;

  return ExitCode::Success;
}
