//                                               -*- C++ -*-
/**
 *  @file  t_Basis_std.cxx
 *  @brief The test file of class Basis for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (Thu, 04 Feb 2010) $
 *  Id:      $Id: t_Basis_std.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;
using namespace OT::Base::Func;
using namespace OT::Base::Type;

typedef LinearCombinationEvaluationImplementation::NumericalMathFunctionCollection NumericalMathFunctionCollection;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  UnsignedLong dimension = 3;
  Description input;
  Description output[dimension];
  for ( UnsignedLong j = 0; j < dimension; ++ j )
  {
    OSS oss;
    oss << "x" << j;
    String in(oss);
    input.add(in);
    output[j].add(in);
  }
  NumericalMathFunctionCollection coll;
  for ( UnsignedLong j = 0; j < dimension; ++ j )
  {
    NumericalMathFunction ei(input, output[j], output[j]);
    coll.add(ei);
  }


  Basis myBasis(coll);

  fullprint << "basis = " << myBasis << std::endl;

  fullprint << "dimension = " << myBasis.getDimension() << std::endl;


  Study myStudy;
  myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
  myStudy.add("myBasis", myBasis);
  myStudy.save();

  Study myStudy2;
  myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
  myStudy2.load();

  Basis basis;
  myStudy2.fillObject("myBasis", basis);
  fullprint << "loaded Basis=" << basis << std::endl;





  return ExitCode::Success;
}
