//                                               -*- C++ -*-
/**
 *  @file  LinearModelTest.hxx
 *  @brief StatTest implements statistical tests
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: LinearModelTest.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_LINEARMODELTEST_HXX
#define OPENTURNS_LINEARMODELTEST_HXX

#include "OTprivate.hxx"
#include "Exception.hxx"
#include "TestResult.hxx"
#include "NumericalSample.hxx"
#include "LinearModel.hxx"

namespace OpenTURNS
{
  namespace Uncertainty
  {
    namespace StatTest
    {

      /**
       * @class LinearModelTest
       *
       */

      class LinearModelTest
      {
      public:

        typedef Base::Common::InternalException         InternalException;
        typedef Base::Stat::TestResult                  TestResult;
        typedef Base::Stat::NumericalSample             NumericalSample;
        typedef Base::Stat::LinearModel                 LinearModel;

        /** Default constructor */
        LinearModelTest();

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelAdjustedRSquared() instead.
         */
        static TestResult LMAdjustedRSquared(const NumericalSample & firstSample,
                                             const NumericalSample & secondSample,
                                             const LinearModel & linearModel,
                                             const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelAdjustedRSquared(const NumericalSample & firstSample,
                                                      const NumericalSample & secondSample,
                                                      const LinearModel & linearModel,
                                                      const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelAdjustedRSquared() instead.
         */
        static TestResult LMAdjustedRSquared(const NumericalSample & firstSample,
                                             const NumericalSample & secondSample,
                                             const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelAdjustedRSquared(const NumericalSample & firstSample,
                                                      const NumericalSample & secondSample,
                                                      const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelFisher() instead.
         */
        static TestResult LMFisher(const NumericalSample & firstSample,
                                   const NumericalSample & secondSample,
                                   const LinearModel & linearModel,
                                   const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelFisher(const NumericalSample & firstSample,
                                            const NumericalSample & secondSample,
                                            const LinearModel & linearModel,
                                            const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelFisher() instead.
         */
        static TestResult LMFisher(const NumericalSample & firstSample,
                                   const NumericalSample & secondSample,
                                   const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelFisher(const NumericalSample & firstSample,
                                            const NumericalSample & secondSample,
                                            const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelResidualMean() instead.
         */
        static TestResult LMResidualMean(const NumericalSample & firstSample,
                                         const NumericalSample & secondSample,
                                         const LinearModel & linearModel,
                                         const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelResidualMean(const NumericalSample & firstSample,
                                                  const NumericalSample & secondSample,
                                                  const LinearModel & linearModel,
                                                  const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelResidualMean() instead.
         */
        static TestResult LMResidualMean(const NumericalSample & firstSample,
                                         const NumericalSample & secondSample,
                                         const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelResidualMean(const NumericalSample & firstSample,
                                                  const NumericalSample & secondSample,
                                                  const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelResidualMean() instead.
         */
        static TestResult LMRSquared(const NumericalSample & firstSample,
                                     const NumericalSample & secondSample,
                                     const LinearModel & linearModel,
                                     const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelRSquared(const NumericalSample & firstSample,
                                              const NumericalSample & secondSample,
                                              const LinearModel & linearModel,
                                              const NumericalScalar level=0.95);

        /**
         * @deprecated
         * This method is deprecated. Use LinearModelResidualMean() instead.
         */
        static TestResult LMRSquared(const NumericalSample & firstSample,
                                     const NumericalSample & secondSample,
                                     const NumericalScalar level=0.95) DEPRECATED;

        /**  */
        static TestResult LinearModelRSquared(const NumericalSample & firstSample,
                                              const NumericalSample & secondSample,
                                              const NumericalScalar level=0.95);

      protected:
        /** Generic invocation of a R script for testing a distribution against a sample */
        static TestResult RunTwoSamplesALinearModelRTest(const NumericalSample & firstSample,
                                                         const NumericalSample & secondSample,
                                                         const LinearModel & linearModel,
                                                         const NumericalScalar level,
                                                         const String & testName)
          /* throw(InternalException) */;

      }; /* class LinearModelTest */

    } /* namespace StatTest */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_LINEARMODELTEST_HXX */
