//                                               -*- C++ -*-
/**
 *  @file  Event.cxx
 *  @brief The class that implements all random vectors
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Event.cxx 1866 2011-04-11 10:32:27Z schueller $
 */

#include "Event.hxx"
#include "CompositeRandomVector.hxx"
#include "Less.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(Event);

      /* Default constructor for save/load */
      Event::Event()
        : RandomVector(CompositeRandomVector(NumericalMathFunction("x", "x"), RandomVector(NumericalPoint(1, 0.0))), Base::Common::Less(), 0.0)
      {
        // Nothing to do
      }

      /* Constructor from RandomVector */
      Event::Event(const RandomVector & antecedent,
                   const ComparisonOperator & op,
                   const NumericalScalar threshold,
                   const String & name)
        /* throw (InvalidArgumentException) */
        : RandomVector(antecedent, op, threshold, name)
      {
        // Nothing to do
      }

      /* String converter */
      String Event::__repr__() const {
        OSS oss;
        oss << "class=" << Event::GetClassName()
            << " name=" << getName()
            << " implementation=" << getImplementation()->__repr__();
        return oss;
      }

      /* String converter */
      String Event::__str__(const String & offset) const {
        return __repr__();
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
