//                                               -*- C++ -*-
/**
 *  @file  TrapezoidalFactory.hxx
 *  @brief Factory for Trapezoidal distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2009-09-30 17:51:57 +0200 (mer. 30 sept. 2009) $
 *  Id:      $Id: TrapezoidalFactory.hxx 1357 2009-09-30 15:51:57Z schueller $
 */
#ifndef OPENTURNS_TRAPEZOIDALFACTORY_HXX
#define OPENTURNS_TRAPEZOIDALFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Trapezoidal.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class TrapezoidalFactory
       */
      class TrapezoidalFactory
        : public Model::DistributionImplementationFactory
      {
      public:

        typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
        typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
        typedef DistributionImplementationFactory::InternalException        InternalException;
        typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
        typedef Model::DistributionImplementation                           DistributionImplementation;

        /** Default constructor */
        TrapezoidalFactory();

        /** Virtual constructor */
        TrapezoidalFactory * clone() const;

        /* Here is the interface that all derived class must implement */
        using DistributionImplementationFactory::build;

        Trapezoidal * build( const NumericalSample & sample ) const;
        Trapezoidal * build( const NumericalPointCollection & parameters ) const;
        Trapezoidal * build() const;

      protected:

        /** likelihood estimate */
        NumericalScalar computeLogLikelihood( const NumericalPoint & x ) const;

        /** wrapper function passed to cobyla */
        static int ComputeObjectiveAndConstraint( int n,
                                                  int m,
                                                  double * x,
                                                  double * f,
                                                  double * con,
                                                  void * state );

        /** only used to pass data to be used in computeLogLikeliHood */
        mutable NumericalSample sample_;

      }; /* class TrapezoidalFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_TRAPEZOIDALFACTORY_HXX */
