//                                               -*- C++ -*-
/**
 *  @file  TracyWidomGSE.cxx
 *  @brief The TracyWidomGSE distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: TracyWidomGSE.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <cmath>
#include "TracyWidomGSE.hxx"
#include "RandomGenerator.hxx"
#include "Exception.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      CLASSNAMEINIT(TracyWidomGSE);

      static Base::Common::Factory<TracyWidomGSE> RegisteredFactory("TracyWidomGSE");

      typedef Base::Stat::RandomGenerator              RandomGenerator;
      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /* Default constructor */
      TracyWidomGSE::TracyWidomGSE()
        : NonEllipticalDistribution("TracyWidomGSE")
      {
        throw NotYetImplementedException(HERE);
        setDimension(1);
        setRange(Interval(-1.0, 1.0));
      }

      /* Comparison operator */
      Bool TracyWidomGSE::operator ==(const TracyWidomGSE & other) const
      {
        return true;
      }

      /* String converter */
      String TracyWidomGSE::__repr__() const {
        OSS oss;
        oss << "class=" << TracyWidomGSE::GetClassName()
            << " name=" << getName()
            << " dimension=" << getDimension();
        return oss;
      }

      /* Virtual constructor */
      TracyWidomGSE * TracyWidomGSE::clone() const
      {
        return new TracyWidomGSE(*this);
      }

      /* Get the DDF of the distribution */
      TracyWidomGSE::NumericalPoint TracyWidomGSE::computeDDF(const NumericalPoint & point) const
      {
        throw NotYetImplementedException(HERE);
        NumericalScalar x(point[0]);
        if ((x <= -1.0) || (x > 1.0)) return NumericalPoint(1, 0.0);
        return NumericalPoint(1, -1.5 * x);
      }


      /* Get the PDF of the distribution */
      NumericalScalar TracyWidomGSE::computePDF(const NumericalPoint & point) const
      {
        throw NotYetImplementedException(HERE);
        NumericalScalar x(point[0]);
        if ((x <= -1.0) || (x > 1.0)) return 0.0;
        return 0.75 * (1.0 + x) * (1.0 - x);
      }


      /* Get the CDF of the distribution */
      NumericalScalar TracyWidomGSE::computeCDF(const NumericalPoint & point, const Bool tail) const
      {
        throw NotYetImplementedException(HERE);
        NumericalScalar x(point[0]);
        if (x <= -1.0) return (tail ? 1.0 : 0.0);
        if (x > 1.0) return (tail ? 0.0 : 1.0);
        if (tail) return 0.5 - x * (0.75 - 0.25 * x * x);
        return 0.5 + x * (0.75 - 0.25 * x * x);
      }

      /** Get the PDFGradient of the distribution */
      TracyWidomGSE::NumericalPoint TracyWidomGSE::computePDFGradient(const NumericalPoint & point) const
      {
        return NumericalPoint(0);
      }

      /** Get the CDFGradient of the distribution */
      TracyWidomGSE::NumericalPoint TracyWidomGSE::computeCDFGradient(const NumericalPoint & point) const
      {
        return NumericalPoint(0);
      }

      /* Get the quantile of the distribution */
      NumericalScalar TracyWidomGSE::computeScalarQuantile(const NumericalScalar prob,
                                                           const Bool tail,
                                                           const NumericalScalar precision) const
      {
        throw NotYetImplementedException(HERE);
        // 2.094395102393195492308429 = 2 * Pi / 3
        if (tail) return 2.0 * cos(0.3333333333333333333333333 * acos(2.0 * prob - 1.0) - 2.094395102393195492308429);
        return 2.0 * cos(0.3333333333333333333333333 * acos(1.0 - 2.0 * prob) - 2.094395102393195492308429);
      }

      /* Get the roughness, i.e. the L2-norm of the PDF */
      NumericalScalar TracyWidomGSE::getRoughness() const
      {
        throw NotYetImplementedException(HERE);
        return 0.6;
      }

      /* Compute the mean of the distribution */
      void TracyWidomGSE::computeMean() const
      {
        // RMT matlab toolbox computation
        mean_ = NumericalPoint(1, -2.306884893241);
        isAlreadyComputedMean_ = true;
      }

      /* Get the standard deviation of the distribution */
      TracyWidomGSE::NumericalPoint TracyWidomGSE::getStandardDeviation() const /* throw(NotDefinedException) */
      {
        // RMT matlab toolbox computation
        return NumericalPoint(1, 0.5177237207726);
      }

      /* Get the skewness of the distribution */
      TracyWidomGSE::NumericalPoint TracyWidomGSE::getSkewness() const /* throw(NotDefinedException) */
      {
        // RMT matlab toolbox computation
        return NumericalPoint(1, 0.16550949435);
      }

      /* Get the kurtosis of the distribution */
      TracyWidomGSE::NumericalPoint TracyWidomGSE::getKurtosis() const /* throw(NotDefinedException) */
      {
        // RMT matlab toolbox computation
        return NumericalPoint(1, 0.0491951565);
      }

      /* Compute the covariance of the distribution */
      void TracyWidomGSE::computeCovariance() const
      {
        covariance_ = CovarianceMatrix(1);
        const NumericalScalar sigma(getStandardDeviation()[0]);
        covariance_(0, 0) = sigma * sigma;
        isAlreadyComputedCovariance_ = true;
      }

      /* Parameters value and description accessor */
      TracyWidomGSE::NumericalPointWithDescriptionCollection TracyWidomGSE::getParametersCollection() const
      {
        // No parameter, return a collection with an empty NumericalPointWithDescription
        return NumericalPointWithDescriptionCollection(1, NumericalPointWithDescription(0));
      }

      /* Method save() stores the object through the StorageManager */
      void TracyWidomGSE::save(StorageManager::Advocate & adv) const
      {
        NonEllipticalDistribution::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void TracyWidomGSE::load(StorageManager::Advocate & adv)
      {
        NonEllipticalDistribution::load(adv);
      }

    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
