//                                               -*- C++ -*-
/**
 *  @file  NormalCopulaFactory.cxx
 *  @brief Factory for NormalCopula distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-07-28 18:31:43 +0200 (Thu, 28 Jul 2011) $
 *  Id:      $Id: NormalCopulaFactory.cxx 2046 2011-07-28 16:31:43Z schueller $
 */
#include <cmath>
#include "NormalCopulaFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /* Default constructor */
      NormalCopulaFactory::NormalCopulaFactory():
        DistributionImplementationFactory()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      NormalCopulaFactory * NormalCopulaFactory::clone() const
      {
        return new NormalCopulaFactory(*this);
      }

      /* Here is the interface that all derived class must implement */

      NormalCopula * NormalCopulaFactory::build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
        if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a NormalCopula distribution from an empty sample";
        return NormalCopula(NormalCopula::GetCorrelationFromKendallCorrelation(sample.computeKendallTau())).clone();
      }

      NormalCopula * NormalCopulaFactory::build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */
      {
        try {
          NormalCopula copula;
          copula.setParametersCollection(parameters);
          return copula.clone();
        }
        catch (InvalidArgumentException & ex)
          {
            throw InternalException(HERE) << "Error: cannot build a NormalCopula from the given parameters";
          }
      }

      NormalCopula * NormalCopulaFactory::build() const /* throw(InvalidArgumentException, InternalException) */
      {
        return NormalCopula().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
