//                                               -*- C++ -*-
/**
 *  @file  Wilks.hxx
 *  @brief Wilks is a static class that gives access to the computation of the sample size for guaranteed upper bound of quantile
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Wilks.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_WILKS_HXX
#define OPENTURNS_WILKS_HXX

#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {


      /**
       * @class Wilks
       */

      class Wilks
      {

      public:

        typedef Base::Common::InvalidArgumentException InvalidArgumentException;

        /** Maximum sample size accessor */
        static UnsignedLong ComputeSampleSize(const NumericalScalar quantileLevel,
                                              const NumericalScalar confidenceLevel,
                                              const UnsignedLong marginIndex=0)
          /* throw(InvalidArgumentException) */;

      private:

        /** Default constructor */
        Wilks() {}

      } ; /* class Wilks */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_WILKS_HXX */
