//                                               -*- C++ -*-
/**
 *  @file  MonteCarlo.cxx
 *  @brief MonteCarlo is an implementation of the hit or miss Monte Carlo simulation method
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: MonteCarlo.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "MonteCarlo.hxx"
#include "ComparisonOperatorImplementation.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /*
       * @class MonteCarlo
       */

      CLASSNAMEINIT(MonteCarlo);

      static Base::Common::Factory<MonteCarlo> RegisteredFactory("MonteCarlo");

      /* Constructor with parameters */
      MonteCarlo::MonteCarlo(const Simulation::Event & event):
        Simulation(event)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      MonteCarlo * MonteCarlo::clone() const
      {
        return new MonteCarlo(*this);
      }

      /* Compute the block sample */
      MonteCarlo::NumericalSample MonteCarlo::computeBlockSample(NumericalSample & realizedEventSample)
      {
        NumericalSample inputSample(event_.getImplementation()->getAntecedent()->getDistribution().getNumericalSample(blockSize_));
        NumericalSample blockSample(event_.getImplementation()->getFunction()(inputSample));
        realizedEventSample = NumericalSample(blockSize_, inputSample.getDimension());
        for (UnsignedLong i = 0; i < blockSize_; ++i)
          {
            inputStrategy_.store(inputSample[i]);
            outputStrategy_.store(blockSample[i]);
            const Bool isRealized(getEvent().getOperator()(blockSample[i][0], event_.getThreshold()));
            if (isRealized)
              {
                blockSample[i][0] = 1.0;
                realizedEventSample[i] = inputSample[i];
              }
            else blockSample[i][0] = 0.0;
          }
        return blockSample;
      }

      /* String converter */
      String MonteCarlo::__repr__() const
      {
        OSS oss;
        oss << "class=" << MonteCarlo::GetClassName()
            << " derived from " << Simulation::__repr__();
        return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
