//                                               -*- C++ -*-
/**
 *  @file  MetaModelAlgorithm.cxx
 *  @brief Implementation for metamodel algorithms
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-06-05 12:11:56 +0200 (Thu, 05 Jun 2008) $
 *  Id:      $Id: MetaModelAlgorithm.cxx 846 2008-06-05 10:11:56Z schueller $
 */

#include "MetaModelAlgorithm.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      CLASSNAMEINIT(MetaModelAlgorithm);

      static Base::Common::Factory<MetaModelAlgorithm> RegisteredFactory("MetaModelAlgorithm");

      /* Default constructor */
      MetaModelAlgorithm::MetaModelAlgorithm(const String & name)
        : Base::Common::PersistentObject( name )
      {
      }

      /* Constructor with parameters */
      MetaModelAlgorithm::MetaModelAlgorithm(const Distribution & distribution,
                                             const NumericalMathFunction & model,
                                             const String & name)
        : Base::Common::PersistentObject( name ),
          distribution_(distribution),
          model_(model)
      {
      }

      /* Virtual constructor */
      MetaModelAlgorithm * MetaModelAlgorithm::clone() const
      {
        return new MetaModelAlgorithm(*this);
      }

      /* String converter */
      String MetaModelAlgorithm::__repr__() const
      {
        OSS oss;
        oss << "class=" << GetClassName()
            << " name=" << getName();
        return oss;
      }



      /* Distribution accessor */
      void MetaModelAlgorithm::setDistribution(const Distribution & distribution)
      {
        distribution_ = distribution;
      }

      MetaModelAlgorithm::Distribution MetaModelAlgorithm::getDistribution() const
      {
        return distribution_;
      }

      /* Response surface computation */
      void MetaModelAlgorithm::run()
      {
        throw NotYetImplementedException(HERE) << " in MetaModelAlgorithm::run()";
      }

      /* Method save() stores the object through the StorageManager */
      void MetaModelAlgorithm::save(StorageManager::Advocate & adv) const
      {
        Base::Common::PersistentObject::save(adv);
        adv.saveAttribute( "distribution_", distribution_ );
        adv.saveAttribute( "model_", model_ );

      }

      /* Method load() reloads the object from the StorageManager */
      void MetaModelAlgorithm::load(StorageManager::Advocate & adv)
      {
        Base::Common::PersistentObject::load(adv);
        adv.loadAttribute( "distribution_", distribution_ );
        adv.loadAttribute( "model_", model_ );
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
