//                                               -*- C++ -*-
/**
 *  @file  IntegrationStrategy.hxx
 *  @brief An implementation of projection strategy as a leastSquares
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_INTEGRATIONSTRATEGY_HXX
#define OPENTURNS_INTEGRATIONSTRATEGY_HXX

#include "ProjectionStrategyImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class IntegrationStrategy
       *
       * An implementation of projection strategy as a leastSquares
       */

      class IntegrationStrategy
        : public ProjectionStrategyImplementation
      {
        CLASSNAME;
      public:

        typedef Base::Common::StorageManager                   StorageManager;
        typedef ProjectionStrategyImplementation::Distribution Distribution;

        // friend class Base::Common::Factory<IntegrationStrategy>;

        /** Default constructor */
        IntegrationStrategy();

        /** Parameter constructor */
        IntegrationStrategy(const Distribution & measure);

        /** Parameter constructor */
        IntegrationStrategy(const WeightedExperiment & weightedExperiment);

        /** Parameter constructor */
        IntegrationStrategy(const Distribution & measure,
                            const WeightedExperiment & weightedExperiment);

        /** Parameter constructor */
        IntegrationStrategy(const NumericalSample & inputSample,
                            const NumericalSample & outputSample,
                            const NumericalPoint & weights);

        /** Parameter constructor */
        IntegrationStrategy(const NumericalSample & inputSample,
                            const NumericalSample & outputSample);

        /** Virtual constructor */
        virtual IntegrationStrategy * clone() const;

        /** String converter */
        String __repr__() const;

        /** Compute the components alpha_k_p_ by projecting the model on the partial L2 basis */
        void computeCoefficients(const NumericalMathFunction & function,
                                 const NumericalMathFunctionCollection & partialBasis,
                                 const Indices & indices,
                                 const Indices & addedRanks,
                                 const Indices & conservedRanks,
                                 const Indices & removedRanks,
                                 const UnsignedLong marginalIndex = 0);

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);


      protected:

      private:

      } ; /* class IntegrationStrategy */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INTEGRATIONSTRATEGY_HXX */
