//                                               -*- C++ -*-
/**
 *  @file  HistoryStrategyImplementation.hxx
 *  @brief This class is a top-level class for the history mechanism of
 *  simulation algorithms. It delegates to its children the effective
 *  history strategy.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: HistoryStrategyImplementation.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_HISTORYSTRATEGYIMPLEMENTATION_HXX
#define OPENTURNS_HISTORYSTRATEGYIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class HistoryStrategyImplementation
       */

      class HistoryStrategyImplementation
        : public Common::PersistentObject
      {

        CLASSNAME;

      public:

        typedef Type::NumericalPoint NumericalPoint;
        typedef Common::StorageManager           StorageManager;

        /** Constructor with parameters */
        explicit HistoryStrategyImplementation();

        /** Virtual constructor */
        virtual HistoryStrategyImplementation * clone() const;

        /** Store the point according to the strategy */
        virtual void store(const NumericalPoint & point);

        /** Reset the history storage through the isInitialized_ flag */
        void reset();

        /** History sample accessor */
        virtual NumericalSample getSample() const;

        /** String converter */
        virtual String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

      protected:
        /** Data container */
        NumericalSample sample_;

        /** Initialization flag */
        Bool isInitialized_;
      } ; /* class HistoryStrategyImplementation */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_HISTORYSTRATEGYIMPLEMENTATION_HXX */
