//                                               -*- C++ -*-
/**
 *  @file  SQPSpecificParameters.hxx
 *  @brief SQPSpecificParameters is an encapsulation of the SQP specific
 *         parameters.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SQP.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_SQPSPECIFICPARAMETERS_HXX
#define OPENTURNS_SQPSPECIFICPARAMETERS_HXX

#include "OTprivate.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class SQP
       * SQP is an actual implementation for
       * NearestPointAlgorithm
       */
      class SQPSpecificParameters
        : public Common::PersistentObject
      {
        typedef Common::StorageManager StorageManager;

        /* Multiplicative decrease of linear step */
        static const NumericalScalar DefaultTau;
        /* Armijo factor */
        static const NumericalScalar DefaultOmega;
        /* Growing factor in penalization term */
        static const NumericalScalar DefaultSmooth;

        CLASSNAME;

      public:
        /** Default constructor */
        SQPSpecificParameters();

        /** Parameters constructor */
        SQPSpecificParameters(const NumericalScalar tau,
                              const NumericalScalar omega,
                              const NumericalScalar smooth);

        /** Virtual constructor */
        virtual SQPSpecificParameters * clone() const;

        /** Tau accessor */
        NumericalScalar getTau() const;
        void setTau(const NumericalScalar tau);

        /** Omega accessor */
        NumericalScalar getOmega() const;
        void setOmega(const NumericalScalar tau);

        /** Smooth accessor */
        NumericalScalar getSmooth() const;
        void setSmooth(const NumericalScalar tau);

        /** String converter */
        String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);


      private:

        /* Multiplicative decrease of linear step */
        NumericalScalar tau_;

        /* Armijo factor */
        NumericalScalar omega_;

        /* Growing factor in penalization term */
        NumericalScalar smooth_;

      }; /* class SQPSpecificParameters */

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SQPSPECIFICPARAMETERS_HXX */
