//                                               -*- C++ -*-
/**
 *  @file  QuadraticLeastSquares.hxx
 *  @brief Second order polynomial response surface by least square
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: QuadraticLeastSquares.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_QUADRATICLEASTSQUARES_HXX
#define OPENTURNS_QUADRATICLEASTSQUARES_HXX

#include "OTprivate.hxx"
#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace MetaModel {

      /**
       * @class QuadraticLeastSquares
       *
       * The class describes the concept of quadratic response surface
       */
      class QuadraticLeastSquares
        : public Base::Common::PersistentObject
      {
        CLASSNAME;
      public:

        typedef Base::Type::NumericalPoint             NumericalPoint;
        typedef Base::Type::Matrix                     Matrix;
        typedef Base::Type::SymmetricTensor            SymmetricTensor;
        typedef Base::Func::NumericalMathFunction      NumericalMathFunction;
        typedef Base::Stat::NumericalSample            NumericalSample;
        typedef Base::Common::InvalidArgumentException InvalidArgumentException;

        /** Constructor with parameters */
        explicit QuadraticLeastSquares(const NumericalSample & dataIn,
                                       const NumericalMathFunction & inputFunction,
                                       const String & name = OT::DefaultName)
          /* throw(InvalidArgumentException) */;

        /** Constructor with parameters */
        explicit QuadraticLeastSquares(const NumericalSample & dataIn,
                                       const NumericalSample & dataOut,
                                       const String & name = OT::DefaultName)
          /* throw(InvalidArgumentException) */;


        /** Virtual constructor */
        virtual QuadraticLeastSquares * clone() const;

        /** String converter */
        String __repr__() const;

        /** Response surface computation */
        void run();

        /** Constant accessor */
        NumericalPoint getConstant() const;

        /** Linear accessor */
        Matrix getLinear() const;

        /** Quadratic accessor */
        SymmetricTensor getQuadratic() const;

        /** Input function accessor */
        NumericalMathFunction getInputFunction() const;

        /** Response surface accessor */
        NumericalMathFunction getResponseSurface() const;

        /** DataIn accessor */
        NumericalSample getDataIn() const;

        /** DataOut accessor */
        void setDataOut(const NumericalSample & dataOut)
          /* throw(InvalidArgumentException) */;
        NumericalSample getDataOut();

      protected:

      private:
        NumericalSample dataIn_;
        NumericalSample dataOut_;
        NumericalMathFunction inputFunction_;
        NumericalMathFunction responseSurface_;
        NumericalPoint constant_;
        Matrix linear_;
        SymmetricTensor quadratic_;

      }; /* class QuadraticLeastSquares */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_QUADRATICLEASTSQUARES_HXX */
