//                                               -*- C++ -*-
/**
 *  @file  LinearTaylor.hxx
 *  @brief First order polynomial response surface by Taylor expansion
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: LinearTaylor.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_LINEARTAYLOR_HXX
#define OPENTURNS_LINEARTAYLOR_HXX

#include "OTprivate.hxx"
#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "Matrix.hxx"
#include "NumericalMathFunction.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace MetaModel {

      /**
       * @class LinearTaylor
       *
       * The class describes the concept of linear taylor response surface
       */
      class LinearTaylor
        : public Base::Common::PersistentObject
      {
        CLASSNAME;
      public:


        typedef Base::Type::NumericalPoint        NumericalPoint;
        typedef Base::Func::NumericalMathFunction NumericalMathFunction;
        typedef Base::Type::Matrix                Matrix;

        /** Default constructor */
        explicit LinearTaylor(const String & name = OT::DefaultName);

        /** Constructor with parameters */
        explicit LinearTaylor(const NumericalPoint & center,
                              const NumericalMathFunction & inputFunction,
                              const String & name = OT::DefaultName);


        /** Virtual constructor */
        virtual LinearTaylor * clone() const;

        /** String converter */
        String __repr__() const;

        /** Response surface computation */
        void run();

        /** Center accessor */
        NumericalPoint getCenter() const;

        /** Constant accessor */
        NumericalPoint getConstant() const;

        /** Linear accessor */
        Matrix getLinear() const;

        /** Input function accessor */
        NumericalMathFunction getInputFunction() const;

        /** Response surface accessor */
        NumericalMathFunction getResponseSurface() const;

      protected:

      private:

        NumericalPoint center_;
        NumericalMathFunction inputFunction_;
        NumericalMathFunction responseSurface_;
        NumericalPoint constant_;
        Matrix linear_;

      }; /* class LinearTaylor */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LINEARTAYLOR_HXX */
