//                                               -*- C++ -*-
/**
 *  @file  BasisSequenceFactory.cxx
 *  @brief A factory for building BasisSequence objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: BasisSequenceFactory.hxx 1649 2010-11-09 12:44:00Z dutka $
 */

#include "BasisSequenceFactory.hxx"
#include "LAR.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      CLASSNAMEINIT(BasisSequenceFactory);

      /* Default constructor */
      BasisSequenceFactory::BasisSequenceFactory()
        : Common::TypedInterfaceObject<BasisSequenceFactoryImplementation>( new LAR() )
      {
        // Nothing to do
      }

      /* Constructor from implementation */
      BasisSequenceFactory::BasisSequenceFactory(const BasisSequenceFactoryImplementation & implementation)
        : Common::TypedInterfaceObject<BasisSequenceFactoryImplementation>( implementation.clone() )
      {
        // Nothing to do
      }

      /* String converter */
      String BasisSequenceFactory::__repr__() const
      {
        return getImplementation()->__repr__();
      }

      String BasisSequenceFactory::__str__(const String & offset) const
      {
        return getImplementation()->__str__( offset );
      }

      /* Verbosity accessor */
      void BasisSequenceFactory::setVerbose(const Bool verbose)
      {
        getImplementation()->setVerbose( verbose );
      }

      Bool BasisSequenceFactory::getVerbose() const
      {
        return getImplementation()->getVerbose();
      }

      /* Method to create new BasisSequence objects */
      BasisSequence BasisSequenceFactory::build(const NumericalSample & x,
						const NumericalSample & y,
						const Basis & psi) const
      {
        return getImplementation()->build( x, y, psi );
      }

      /* Stopping criterion on the L1-norm of the coefficients accessor */
      void BasisSequenceFactory::setMaximumRelativeConvergence(const NumericalScalar coefficientsPaths)
      {
        getImplementation()->setMaximumRelativeConvergence(coefficientsPaths);
      }

      NumericalScalar BasisSequenceFactory::getMaximumRelativeConvergence() const
      {
        return getImplementation()->getMaximumRelativeConvergence();
      }


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
