//                                               -*- C++ -*-
/**
 *  @file  CenteredFiniteDifferenceHessian.hxx
 *  @brief Class for the creation of a numerical math hessian implementation
 *         form a numerical math evaluation implementation by using centered
 *         finite difference formula.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: CenteredFiniteDifferenceHessian.hxx 1866 2011-04-11 10:32:27Z schueller $
 */

#ifndef OPENTURNS_CENTEREDFINITEDIFFERENCEHESSIAN_HXX
#define OPENTURNS_CENTEREDFINITEDIFFERENCEHESSIAN_HXX

#include "FiniteDifferenceHessian.hxx"
#include "NumericalMathHessianImplementation.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "Exception.hxx"
#include "NumericalPoint.hxx"
#include "SymmetricTensor.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Diff {


      /**
       * @class CenteredFiniteDifferenceHessian
       * @brief This class is for the creation of a numerical math hessian implementation
       * @ingroup Function
       *
       * This class is for the creation of a numerical math hessian implementation
       * form a numerical math evaluation implementation by using centered
       * finite difference formula
       */
      class CenteredFiniteDifferenceHessian
        : public Diff::FiniteDifferenceHessian
      {
        CLASSNAME;
      public:

        static const NumericalScalar DefaultEpsilon;

        typedef Func::NumericalMathHessianImplementation::Description              Description;
        typedef Func::NumericalMathHessianImplementation::SymmetricTensor          SymmetricTensor;
        typedef Func::NumericalMathHessianImplementation::NumericalPoint           NumericalPoint;
        typedef Func::NumericalMathHessianImplementation::InvalidArgumentException InvalidArgumentException;
        typedef Func::NumericalMathHessianImplementation::InternalException        InternalException;
        typedef Func::NumericalMathHessianImplementation::StorageManager           StorageManager;
        typedef Common::InvalidDimensionException                                  InvalidDimensionException;
        typedef Pointer<Func::NumericalMathEvaluationImplementation>               EvaluationImplementation;

        /** Default constructor */
        CenteredFiniteDifferenceHessian();
        /** Parameter constructor */
        CenteredFiniteDifferenceHessian(const NumericalPoint & epsilon,
                                        const EvaluationImplementation & p_evaluation)
          /* throw(InvalidDimensionException) */;

        /** Second parameter constructor */
        CenteredFiniteDifferenceHessian(const NumericalScalar epsilon,
                                        const EvaluationImplementation & p_evaluation)
          /* throw(InvalidDimensionException) */;

        /** Constructor with FiniteDifferenceStep */
        CenteredFiniteDifferenceHessian(const FiniteDifferenceStep & finiteDifferenceStep,
                                        const EvaluationImplementation & p_evaluation);

        /* Virtual constructor */
        virtual CenteredFiniteDifferenceHessian * clone() const;

        /* Comparison operator */
        Bool operator ==(const CenteredFiniteDifferenceHessian & other) const;

        /* String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset) const;



        /* Here is the interface that all derived class must implement */

        /** This method computes the hessian at some point
         * @param in The point where the hessian is computed
         * @result A tensor
         */
        virtual SymmetricTensor hessian(const NumericalPoint & inP) const
          /* throw(InvalidArgumentException, InternalException) */;

      protected:


      private:

      }; /* class CenteredFiniteDifferenceHessian */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CENTEREDFINITEDIFFERENCEHESSIAN_HXX */
