//                                               -*- C++ -*-
/**
 * @file  TTY.hxx
 * @brief This file provides definitions for tty control sequences
 *
 * (C) Copyright 2005-2011 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2011-04-08 17:04:10 +0200 (Fri, 08 Apr 2011) $
 */

#ifndef OPENTURNS_TTY_HXX
#define OPENTURNS_TTY_HXX

#include "OTprivate.hxx"

namespace OpenTURNS {

  struct TTY
  {

    enum Color {
      DEFAULT = 0,
      BOLD,
      UNDERLINE,
      BLINK,
      BLACKFG,
      REDFG,
      GREENFG,
      YELLOWFG,
      BLUEFG,
      PURPLEFG,
      CYANFG,
      WHITEFG,
      BLACKBG,
      REDBG,
      GREENBG,
      YELLOWBG,
      BLUEBG,
      PURPLEBG,
      CYANBG,
      WHITEBG,
      LASTCOLOR /* for internal usage only */
    };

    /** Return a control sequence corresponding to the current color */
    static const char * GetColor( Color c );

    /** Define the colorization strategy. Flag = true if colored output */
    static void ShowColors( Bool flag );

    /** Query the colorization strategy. Return true if colored output */
    static Bool ColoredOutput();

  }; // struct TTY

} // namespace OpenTURNS

#endif /* OPENTURNS_TTY_HXX */
