// SWIG file UserDefined.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: UserDefined.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "UserDefined.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Distribution::UserDefined::Pair>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Uncertainty::Distribution::UserDefined::Pair *
  buildObjectFromPySequence<OpenTURNS::Uncertainty::Distribution::UserDefined::Pair>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );

    const UnsignedLong size = PySequence_Fast_GET_SIZE( pyObj );
    if (size != 2) {
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence object has incorrect size " << size << ". Must be 2.";
    }
    PyObject * elt1 = PySequence_Fast_GET_ITEM( pyObj, 0 );
    check<_PyFloat_>( elt1 );
    PyObject * elt2 = PySequence_Fast_GET_ITEM( pyObj, 1 );
    check<_PyFloat_>( elt2 );
    return new OpenTURNS::Uncertainty::Distribution::UserDefined::Pair( convert<_PyFloat_,OpenTURNS::NumericalScalar>( elt1 ),
								        convert<_PyFloat_,OpenTURNS::NumericalScalar>( elt2 ) );
  }

  template <>
  inline
  OpenTURNS::Uncertainty::Distribution::UserDefined::Pair
  convert<_PySequence_,OpenTURNS::Uncertainty::Distribution::UserDefined::Pair>(PyObject * pyObj)
  {
    OpenTURNS::Base::Common::Pointer<OpenTURNS::Uncertainty::Distribution::UserDefined::Pair> ptr = buildObjectFromPySequence<OpenTURNS::Uncertainty::Distribution::UserDefined::Pair>( pyObj );
    return *ptr;
  }

  template <>
  inline
  OpenTURNS::Uncertainty::Distribution::UserDefined::Pair
  convert<_PyObject_,OpenTURNS::Uncertainty::Distribution::UserDefined::Pair>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Uncertainty::Distribution::UserDefined::Pair *"), 0 |  0 ))) {
      OpenTURNS::Uncertainty::Distribution::UserDefined::Pair * p_hp = reinterpret_cast< OpenTURNS::Uncertainty::Distribution::UserDefined::Pair * >( ptr );
      return *p_hp;

    } else if (isAPython<_PySequence_>( pyObj )) {
      return convert<_PySequence_,OpenTURNS::Uncertainty::Distribution::UserDefined::Pair>( pyObj );

    } else {
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is neither an UserDefinedPair nor an object convertible to an UserDefinedPair";
    }
    return OpenTURNS::Uncertainty::Distribution::UserDefined::Pair();
  }


} /* namespace OpenTURNS */

%}

%include UserDefined.hxx


namespace OpenTURNS { namespace Uncertainty { namespace Distribution {
class UserDefinedPair {
  public:
    UserDefinedPair();
    UserDefinedPair(OpenTURNS::Base::Type::NumericalPoint x, NumericalScalar p);
    ~UserDefinedPair();    
    String __repr__() const;
}; /* end struct Pair */



}}}

%template(UserDefinedPairCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::UserDefinedPair>;

namespace OpenTURNS { namespace Uncertainty { namespace Distribution {

%extend UserDefined {
  UserDefined(const OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::UserDefinedPair> & collection)
  {
    return new OpenTURNS::Uncertainty::Distribution::UserDefined(collection);
  }
}

}}}
namespace OpenTURNS { namespace Uncertainty { namespace Distribution { %extend UserDefined { UserDefined(const UserDefined & other) { return new OpenTURNS::Uncertainty::Distribution::UserDefined(other); } } }}}
