//                                               -*- C++ -*-
/**
 *  @file  MultiNomial.hxx
 *  @brief The MultiNomial distribution
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: MultiNomial.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_MULTINOMIAL_HXX
#define OPENTURNS_MULTINOMIAL_HXX

#include "OTprivate.hxx"
#include "DiscreteDistribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {


      /**
       * @class MultiNomial
       *
       * The MultiNomial distribution.
       */
      class MultiNomial
        : public Model::DiscreteDistribution
      {
        CLASSNAME;
      public:

        typedef Base::Common::InvalidArgumentException               InvalidArgumentException;
        typedef Model::DiscreteDistribution                          DiscreteDistribution;  // required by SWIG
        typedef DiscreteDistribution::NumericalPoint                 NumericalPoint;
        typedef DiscreteDistribution::NumericalSample                NumericalSample;
        typedef DiscreteDistribution::CovarianceMatrix               CovarianceMatrix;
        typedef DiscreteDistribution::NumericalPointWithDescriptionCollection       NumericalPointWithDescriptionCollection;
        typedef DiscreteDistribution::NotDefinedException            NotDefinedException;


        /** Default constructor */
        MultiNomial()
          /* throw (InvalidArgumentException) */;


        /** Parameters constructor */
        MultiNomial(const NumericalPoint & p,
                    const UnsignedLong n)
          /* throw (InvalidArgumentException) */;


        /** Comparison operator */
        Bool operator ==(const MultiNomial & other) const;

        /** String converter */
	String __repr__() const;



        /* Interface inherited from Distribution */

        /** Virtual constructor */
        virtual MultiNomial * clone() const;

        /** Get one realization of the distribution */
        NumericalPoint getRealization() const;

        /** Get the PDF of the distribution */
        using DiscreteDistribution::computePDF;
        NumericalScalar computePDF(const NumericalPoint & point) const;

        /** Get the CDF of the distribution */
        using DiscreteDistribution::computeCDF;
        NumericalScalar computeCDF(const NumericalPoint & point, const Bool tail = false) const;

        /** Get the PDFGradient of the distribution */
        NumericalPoint computePDFGradient(const NumericalPoint & point) const;

        /** Get the CDFGradient of the distribution */
        NumericalPoint computeCDFGradient(const NumericalPoint & point) const;

        /** Get the quantile of the distribution */
        NumericalPoint computeQuantile(const NumericalScalar prob,
                                       const Bool tail = false) const;

        /** Get the mean of the distribution */
        NumericalPoint getMean() const /* throw(NotDefinedException) */;

        /** Get the covariance of the distribution */
        CovarianceMatrix getCovariance() const /* throw(NotDefinedException) */;

        /** Parameters value and description accessor */
        NumericalPointWithDescriptionCollection getParametersCollection() const;

        /* Interface specific to MultiNomial */

        /** P vector accessor */
        void setP(const NumericalPoint & p)
          /* throw (InvalidArgumentException) */;
        NumericalPoint getP() const;

        /** N accessor */
        void setN(const UnsignedLong n);
        UnsignedLong getN() const;

      protected:


      private:

        /** The vector of probabilities of the MultiNomial distribution */
        NumericalPoint p_;

        /** The range of the output */
        UnsignedLong n_;

      }; /* class MultiNomial */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_MULTINOMIAL_HXX */
