//                                               -*- C++ -*-
/**
 *  @file  RootStrategyImplementation.hxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: RootStrategyImplementation.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_ROOTSTRATEGYIMPLEMENTATION_HXX
#define OPENTURNS_ROOTSTRATEGYIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "Solver.hxx"
#include "Collection.hxx"
#include "Exception.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class RootStrategyImplementation
       */

      class RootStrategyImplementation
	: public Base::Common::PersistentObject
      {

	/** Distance from the origin at which the radial density is negligible */
	static const NumericalScalar DefaultMaximumDistance;
	/** Step-size for the detection of the sign changes along a direction */
	static const NumericalScalar DefaultStepSize;

	CLASSNAME;
      public:

	typedef Base::Common::InvalidArgumentException  InvalidArgumentException;
	typedef Base::Common::NotDefinedException       NotDefinedException;
	typedef Base::Type::Collection<NumericalScalar> NumericalScalarCollection;
	typedef Base::Solver::Solver                    Solver;
	typedef Solver::NumericalMathFunction           NumericalMathFunction;
	typedef Solver::InternalException               InternalException;
	typedef Solver::InvalidDimensionException       InvalidDimensionException;

	/** Default constructor with Brent solver */
	explicit RootStrategyImplementation();

	/** Constructor with parameters */
	RootStrategyImplementation(const Solver & solver);

	/** Constructor with parameters */
	RootStrategyImplementation(const Solver & solver,
				   const NumericalScalar maximumDistance,
				   const NumericalScalar stepSize);


	/** Virtual constructor */
	virtual RootStrategyImplementation * clone() const;

	/** Solve gives all the roots found applying the root strategy */
	virtual NumericalScalarCollection solve(const NumericalMathFunction & function,
						const NumericalScalar value);

	/** Solver accessor */
	void setSolver(const Solver & solver);
	Solver getSolver() const;

	/** Maximum distance accessor */
	void setMaximumDistance(const NumericalScalar maximumDistance);
	NumericalScalar getMaximumDistance() const;

	/** Step size accessor */
	void setStepSize(const NumericalScalar stepSize);
	NumericalScalar getStepSize() const;

	/** Value of the performance function at the origin accessor */
	void setOriginValue(const NumericalScalar originValue);
	NumericalScalar getOriginValue() const;

	/** String converter */
	virtual String __repr__() const;

      protected:

      private:
	Solver solver_;
	NumericalScalar maximumDistance_;
	NumericalScalar stepSize_;
	mutable Bool isAlreadyComputedOrignValue_;
	NumericalScalar originValue_;

      } ; /* class RootStrategyImplementation */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ROOTSTRATEGYIMPLEMENTATION_HXX */
