//                                               -*- C++ -*-
/**
 *  @file  SVMKernel.hxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-07-03 14:14:36 +0200 (Thu, 03 Jul 2008) $
 *  Id:      $Id: SVMKernel.hxx 870 2008-07-03 12:14:36Z schueller $
 */
#ifndef OPENTURNS_SVMKERNEL_HXX
#define OPENTURNS_SVMKERNEL_HXX

#include "TypedInterfaceObject.hxx"
#include "SVMKernelImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class SVMKernel
       */

      class SVMKernel
	: public Base::Common::TypedInterfaceObject<SVMKernelImplementation>
      {

	CLASSNAME;

      public:

	typedef SVMKernelImplementation::NumericalScalar		NumericalScalar;
	typedef SVMKernelImplementation::NumericalPoint			NumericalPoint;
	typedef SVMKernelImplementation::NumericalPointWithDescription	NumericalPointWithDescription;
	typedef SVMKernelImplementation::SymmetricMatrix		SymmetricMatrix;
	typedef SVMKernelImplementation::InvalidArgumentException	InvalidArgumentException;
	typedef SVMKernelImplementation::InternalException		InternalException;
	typedef Base::Common::Pointer<SVMKernelImplementation>          Implementation;

	/** Default constructor */
	SVMKernel();

	/** Constructor with parameters */
	SVMKernel(const SVMKernelImplementation & implementation);

	/** Constructor with parameters */
	SVMKernel(Implementation & p_implementation);

	/** String converter */
	String __repr__() const;

	/** String converter */
	String __str__() const;

	/** Parameter accessor */
	NumericalScalar getParameter() const;
	void setParameter(NumericalScalar value);

	/** Parameters value and description accessor */
	NumericalPointWithDescription getParameters() const;
	void setParameters(const NumericalPointWithDescription & parameters);

	/** Operator () */
	NumericalScalar operator () (const NumericalPoint & x1, const NumericalPoint & x2) const;

	/** Partial Gradient */
	NumericalPoint partialGradient(const NumericalPoint & x1, const NumericalPoint & x2) const;

	/** Partial hessian */
	SymmetricMatrix partialHessian(const NumericalPoint & x1, const NumericalPoint & x2) const;

      } ; /* class SVMKernel */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SVMKERNEL_HXX */
