//                                               -*- C++ -*-
/**
 *  @file  NumericalMathHessianImplementationFactory.hxx
 *  @brief The class NumericalMathHessianImplementationFactory creates NumericalMathHessianImplementation from external codes
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NumericalMathHessianImplementationFactory.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_NUMERICALMATHHESSIANIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_NUMERICALMATHHESSIANIMPLEMENTATIONFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "Pointer.hxx"
#include "Exception.hxx"
#include "NumericalMathHessianImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class NumericalMathHessianImplementationFactory
       *
       * NumericalMathHessianImplementationFactory creates NumericalMathHessianImplementation from external codes
       */

      class NumericalMathHessianImplementationFactory
	: public Common::Object
      {
	CLASSNAME;
      public:

	/* Some typedefs to ease reading */
	typedef Common::Pointer<NumericalMathHessianImplementation> Implementation;
	typedef Common::InvalidArgumentException InvalidArgumentException;

	/** Default constructor */
	NumericalMathHessianImplementationFactory();


	/** Implementation creation */
	Implementation buildImplementation(const String & functionName) const
	  /* throw(InvalidArgumentException) */;
	  
	/** String converter */
	virtual String __repr__() const;



      protected:

	/* Here is the interface that all derived classes must implement */

	/** Object builder */
	virtual NumericalMathHessianImplementation * buildObject(const String & functionName) const = 0;



      private:

      }; /* class NumericalMathHessianImplementationFactory */

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NUMERICALMATHHESSIANIMPLEMENTATIONFACTORY_HXX */
