/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef MAINWINDOW_H

#define MAINWINDOW_H
#include "config.h"
#include <sys/time.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include "resource.h"
#include "paths.h"

class NedPage;
class NedNote;
class NedCommandHistory;
class NedCommandList;
class NedChordOrRest;
class NedSystem;
class NedStaff;
class NedFreeReplaceable;
class NedFreeText;
class NedImporter;
class NedMusicXMLImport;
class ScoreInfo;
struct paper_info_struct;

struct staff_context_str {
	char *m_staff_name;
	int m_key_signature_number;
	int m_clef_number;
	int m_clef_octave_shift;
	unsigned char m_midi_volume;
	unsigned char m_current_midi_volume;
	unsigned char m_midi_pan;
	unsigned char m_midi_chorus;
	unsigned char m_midi_reverb;
	unsigned char m_midi_program;
	unsigned char m_midi_channel;
	unsigned int m_flags;
#define BRACE_START   (1 << 0)
#define BRACE_END     (1 << 1)
#define BRACKET_START (1 << 2)
#define BRACKET_END   (1 << 3)
#define CON_BAR_START (1 << 4)
#define CON_BAR_END   (1 << 5)
	unsigned long long m_crescendo_midi_start;
	unsigned long long m_crescendo_midi_end;
	unsigned char m_crescendo_start_volume;
	unsigned char m_crescendo_end_volume;
	int m_pitch_offs;
	bool m_muted;

};

class SpecialMeasure {
	public:
		SpecialMeasure() {type = 0; measure = NULL;}
		void setTimeSignature(unsigned short num, unsigned short denom) {
			numerator = num; denominator = denom;
			measure_duration = numerator * WHOLE_NOTE / denominator;
		}
#define FIELD_BITS 8
#define REP_TYPE_START_BIT 0
#define START_TYPE_START_BIT 8
#define END_TYPE_START_BIT 16 
#define TIMESIG_TYPE_START_BIT 24

#define REP_TYPE_MASK (((1 << FIELD_BITS) - 1) << REP_TYPE_START_BIT)
#define START_TYPE_MASK (((1 << FIELD_BITS) - 1) << START_TYPE_START_BIT)
#define END_TYPE_MASK (((1 << FIELD_BITS) - 1) << END_TYPE_START_BIT)
#define TIMESIG_TYPE_MASK (((1 << FIELD_BITS) - 1) << TIMESIG_TYPE_START_BIT)

		unsigned int type;
#define REPEAT_OPEN  (1 << REP_TYPE_START_BIT)
#define REPEAT_CLOSE (2 << REP_TYPE_START_BIT)
#define REPEAT_OPEN_CLOSE 3
#define REP1START (1 << START_TYPE_START_BIT)
#define REP1END   (1 << END_TYPE_START_BIT)
#define REP2START (2 << START_TYPE_START_BIT)
#define REP2END   (2 << END_TYPE_START_BIT)
#define TIMESIG   (1 << TIMESIG_TYPE_START_BIT)
		int measure_number;
		unsigned int measure_duration;
		NedMeasure *measure;
		unsigned short numerator, denominator;
		bool isNear(double x, double y);
};

#define NO_LYRICS -1 
#define LYRICS1   0
#define LYRICS2   1
#define LYRICS3   2
#define LYRICS4   3
#define LYRICS5   4

#define MAX_STAFFS 100

class NedMainWindow {
	public:
		NedMainWindow();
		void createLayout(char *fname, char *yelparg);
		double getCurrentZoomFactor() {return m_current_zoom;}
		int getCurrentZoomLevel() {return m_current_zoom_level;}
		unsigned int getCurrentLength();
		int getCurrentNoteHead();
		unsigned int getStatus();
		bool getRestMode();
		int getLyricsMode();
		int getDotCount();
		NedCommandHistory *getCommandHistory() {return m_command_history;}
		double getLeftX();
		double getTopY();
		NedNote *m_selected_note;
		NedChordOrRest *m_selected_chord_or_rest;
		NedFreeReplaceable *m_selected_free_replaceable;
		SpecialMeasure *m_selected_spec_measure;
		GdkCursor *m_hand, *m_pointer, *m_pencil;
		NedSystem *getNextSystem(NedPage *page, NedCommandList *command_list = NULL);
		NedPage *getNextPage(NedPage *page, NedCommandList *command_list = NULL);
		NedPage *getPreviousPage(NedPage *page);
		int getSorting(NedPage *this_page, NedStaff *this_staff, NedPage *other_page, NedStaff *other_staff);
#ifdef WITH_TIME_TEST
		struct timeval m_last_mouse_motion_time;
#endif
		void setUnRedoButtons(bool execute_possible, bool unexecute_possible);
		void repaint();
		void repaintDuringReplay(NedNote *notes[], int num_notes);
		void reposit(NedCommandList *command_list = NULL, NedPage *start_page = NULL, NedSystem *start_system = NULL, bool full = false,  bool with_progress_bar = false);
		void renumberMeasures(NedSystem *start_system = NULL, int measure_number = 1, bool force = false);
		staff_context_str m_staff_contexts[MAX_STAFFS];
		int getNumerator() {return m_numerator;}
		int getDenominator() {return m_denominator;}
		bool isTimsigChangingMeasure(int meas_num);
		unsigned int getMeasureDuration(int meas_num);
		bool findTimeOfMeasure(int meas_num, unsigned long long *meas_time);
		int getNumerator(int meas_num);
		int getDenominator(int meas_num);
		int getPreStaffCount() {return m_pre_staffcount;}
		void stopReplay();
		void setVisibleSystem(NedSystem *system);
		void setVisiblePage(NedPage *page);
		void setVisible(NedNote *note);
		void setVisible(NedChordOrRest *chor_or_rest);
		void setSelected(NedChordOrRest *chord_or_rest, NedNote *note);
		NedPage *getLastPage();
		ScoreInfo *getScoreInfo() {return m_score_info;}
		double getFirstPageYOffs() {return m_first_page_yoffs;}
		double getMidiTempoInverse() {return m_midi_tempo_inverse;}
		void updatePageCounter();
		void renumberPages();
		int getStaffCount() {return m_staff_count;}
		void do_remove_last_staff();
		bool do_import_from_other(NedImporter *im);
		void do_lily_export(FILE *fp);
		void deleteStaff(int staff_number);
		void shiftStaff(int staff_number, int position);
		void restoreStaff(int staff_number, staff_context_str *staff_context);
		unsigned int determineVolume(NedChordOrRest *element, int staff_nr);
		double determineTempoInverse(NedChordOrRest *element);
		GtkWidget *getDrawingArea() {return m_drawing_area;}
		GtkWidget *getWindow() {return m_main_window;}
		struct paper_info_struct *getCurrentPaper() {return m_current_paper;}
		bool getPortrait() {return m_portrait;}
		void reconfig_paper(bool do_reposit, struct paper_info_struct *paper_type, bool portrait);
		void resetPointerLastTouchedSystems() {m_last_touched_system = NULL;}
		bool isLastTouchedSystem(NedSystem *system);
		int getCurrentVoice();
		bool doPaintColored() {return m_paint_colored;}
		bool doDrawPostscript() {return m_draw_postscript;}
		int m_start_measure_number_for_renumbering;
		NedSystem *m_start_system_for_renumbering;
		bool needsARepLine(int measure_number);
		int getSpecialType() {return m_special_type;}
		int getSpecialSubType() {return m_special_sub_type;}
		unsigned int getSpecial(int meas_num);
		SpecialMeasure *getSpecialMeasure(int meas_num);
		void resetSpecialType() {m_special_type = m_special_sub_type = -1;}
		void setAndUpdateClefTypeAndKeySig();
		double getFirstSystemIndent() {return m_first_system_indent;}
		unsigned int getUpBeatInverse() {return m_upbeat_inverse;}
		int getFileVersion() {return m_file_version;}
		NedFreeReplaceable *m_freetext;
	private: 
		GList *m_special_measures;
		int setSpecial(int measnum, int mtype);
		void setSpecialTimesig(int measnum, int num, int denom, int *oldnum, int *olddenom, bool do_reposit = true);
		static gint compare_spec_measures_according_measnum(gconstpointer ptr1, gconstpointer ptr2);
		void readSpecMeasures(FILE *fp, GList **new_spec_measures);
		bool conflictWithOhterSpecMeasure(int measnum, int dir);
		void testAlternativeState(NedCommandList *command_list, NedMeasure *measure, bool alter1, bool alter2);
		void checkForElementsToSplit(NedCommandList *command_list);
		void import_from_other(NedImporter *im, const char *filter_name, const char *pat1, const char *pat2, const char *label, char **last_dir);
		void deleteEmptyPagesAtEnd();
		void find_new_cursor_pos(guint keyval, int *x, int *y);
		void disconnectKeys();
		bool getTiedMode();
		void resetSomeButtons();
		void resetLyricsMode();
		void moveSpecMeasure(SpecialMeasure *spec, int dir);
		bool deleteEnclosedBras();
		bool deleteEnclosedConnections();
		void computeSystemIndent();
		unsigned int getMainWindowStatus();
		void modeChange(unsigned int stat, GtkAction *action);;
		char *m_start_file_name;
		int m_last_line_during_key_insertion;
		NedStaff *m_last_staff_during_key_insertion;
		double m_current_zoom;
		double m_leftx, m_topy;
		double m_leftx0, m_topy0;
		double m_mouse_x, m_mouse_y;
		int m_current_zoom_level;
		int m_special_type;
		int m_special_sub_type;
		GtkWidget *m_drawing_area;
		GtkWidget *m_page_selector;
		static cairo_status_t writefunc(void *fdv,  const unsigned char *data, unsigned int length);
		void do_export_ps(FILE *psfile);
		GList *m_pages;
		void updateRecentFiles();
		int m_recentFileMergeId;
		NedCommandHistory *m_command_history;
		void do_restore(FILE *fp, char *filename);
		void do_staff_config(int staff_number);
		void setToPage(int page_nr);
		void computeScoreTextExtends();
		int m_numerator, m_denominator;
		int m_staff_count, m_pre_staffcount;
		void replay(bool on);
		bool m_config_changed;
		double m_midi_tempo_inverse;
		NedSystem *m_last_touched_system;
		struct timeval m_last_motion_call;
		ScoreInfo *m_score_info;
		double m_first_page_yoffs;
		unsigned int m_upbeat_inverse;

		GtkUIManager *m_ui_manager;
		GtkWidget *m_gracebar;
		GtkWidget *m_drumbar;
		GtkWidget *m_more_acc_bar;
		GtkAction *m_undo_action, *m_redo_action;
		GtkToggleAction *m_sharp_action, *m_flat_action, *m_natural_action, *m_insert_erease_mode_action;
		GtkToggleAction *m_stacc_action, *m_staccatissimo_action;
		GtkToggleAction *m_tenuto_action;
		GtkToggleAction *m_sforzato_action;
		GtkToggleAction *m_sforzando_action;
		GtkToggleAction *m_bow_up_action;
		GtkToggleAction *m_bow_down_action;
		GtkToggleAction *m_ped_on_action;
		GtkToggleAction *m_ped_off_action;
		GtkToggleAction *m_trill_action, *m_prall_action, *m_open_action, *m_mordent_action;
		GtkToggleAction *m_arpeggio_action, *m_fermata_action;
		GtkToggleAction *m_dsharp_action, *m_dflat_action;
		GtkToggleAction *m_shift_action, *m_keyboard_insert_action;
		GtkToggleAction *m_pause_action, *m_dotted_action, *m_ddotted_action;
		GtkToggleAction *m_tie_action;
		GtkToggleAction *m_replay_action;
		GtkActionGroup *m_menu_action_group;
		GtkActionGroup *m_open_recent_action_group;
		GtkActionGroup *m_note_head_action_group;
		GtkActionGroup *m_grace_action_group;
		GtkActionGroup *m_more_acc_action_group;
		GSList *m_voice_buttons;
		GSList *m_note_length_buttons;
		GSList *m_note_head_buttons;
		GtkAction *m_recent_actions[MAX_RECENT_FILES];
		GtkAction *remove_page_action;
		GtkWidget *m_v1bu, *m_v2bu, *m_v3bu, *m_v4bu;
		GtkWidget *m_main_vbox;
		GtkWidget *m_extra_bar_hbox;

		void draw (cairo_t *cr, int width, int height);
		void setTopLeft(double x, double y);
		void setTopRelative(double y_incr);
		bool setPageRelative(int y_incr);
		void setButtons();
		void resetButtons();

		char m_current_filename[4096];

		static const GtkActionEntry main_tools[];
		static const GtkRadioActionEntry note_actions[];
		static const GtkToggleActionEntry toogle_buttons[];
		static const GtkToggleActionEntry accessory_buttons[];
		static const GtkToggleActionEntry toggle_mode_buttons[];
		static const GtkToggleActionEntry insert_erease_button[];
		static const GtkRadioActionEntry grace_actions[];
		static const GtkToggleActionEntry more_acc_buttons[];
		static const GtkRadioActionEntry note_head_actions[];
		static const GtkActionEntry file_entries[];
		static const char *guiDescription;
		static gboolean handle_expose (GtkWidget *widget,
			 GdkEventExpose *event, gpointer data);
		static gboolean scroll_event_handler(GtkWidget *widget, GdkEventScroll *event, gpointer data);
		GtkWidget *m_main_window;
		void storeScore(FILE *fp);
		GdkRectangle m_selection_rect;
		GList *m_selected_group;
		GList *m_main_clip_board;
		int m_number_of_first_selected_staff, m_number_of_last_selected_staff;

		static void zoom_in(GtkWidget *widget, void *data);
		static void zoom_out(GtkWidget *widget, void *data);
		static void quit_app(GtkWidget *widget, void *data);
		static void new_file(GtkWidget *widget, void *data);
		static void save_score(GtkWidget *widget, void *data);
		static void save_score_as(GtkWidget *widget, void *data);
		static void restore_score(GtkWidget *widget, void *data);
		static void print_file(GtkWidget *widget, void *data);
		static void import_musicxml(GtkWidget *widget, void *data);
		static void import_midi(GtkWidget *widget, void *data);
		static void export_midi(GtkWidget *widget, void *data);
		static void export_lily(GtkWidget *widget, void *data);
		static void insert_tuplet(GtkWidget *widget, void *data);
		static void set_brace_system_delimiter(GtkWidget *widget, void *data);
		static void set_bracket_system_delimiter(GtkWidget *widget, void *data);
		static void set_connected_bar_line(GtkWidget *widget, void *data);
		static void remove_system_delimiter(GtkWidget *widget, void *data);
		static void remove_tuplet(GtkWidget *widget, void *data);
		static void append_page(GtkWidget *widget, void *data);
		static void insert_page(GtkWidget *widget, void *data);
		static void insert_keysig(GtkWidget *widget, void *data);
		static void insert_lines(GtkWidget *widget, void *data);
		static void insert_signs(GtkWidget *widget, void *data);
		static void insert_slur(GtkWidget *widget, void *data);
		static void insert_accelerato(GtkWidget *widget, void *data);
		static void insert_ritardando(GtkWidget *widget, void *data);
		static void append_staff(GtkWidget *widget, void *data);
		static void insert_ppp(GtkAction *widget, gpointer data);
		static void insert_pp(GtkAction *widget, gpointer data);
		static void insert_p(GtkAction *widget, gpointer data);
		static void insert_mp(GtkAction *widget, gpointer data);
		static void insert_sp(GtkAction *widget, gpointer data);
		static void insert_mf(GtkAction *widget, gpointer data);
		static void insert_sf(GtkAction *widget, gpointer data);
		static void insert_f(GtkAction *widget, gpointer data);
		static void insert_ff(GtkAction *widget, gpointer data);
		static void insert_fff(GtkAction *widget, gpointer data);
		static void insert_tempo(GtkAction *widget, gpointer data);
		static void insert_text(GtkAction *widget, gpointer data);
		static void set_lyrics_mode1(GtkAction *widget, gpointer data);
		static void set_lyrics_mode2(GtkAction *widget, gpointer data);
		static void set_lyrics_mode3(GtkAction *widget, gpointer data);
		static void set_lyrics_mode4(GtkAction *widget, gpointer data);
		static void set_lyrics_mode5(GtkAction *widget, gpointer data);
		static void remove_page(GtkWidget *widget, void *data);
		static void remove_empty_pages(GtkWidget *widget, void *data);
		static void set_upbeat_measure(GtkWidget *widget, void *data);
		static void set_upbeat_start(GtkWidget *widget, void *data);
		static void edit_score_info(GtkWidget *widget, void *data);
		static void mute_staves(GtkWidget *widget, void *data);
		static void config_midi(GtkWidget *widget, void *data);
		static void config_paper(GtkWidget *widget, void *data);
		static void show_about(GtkWidget *widget, void *data);
#ifdef YELP_PATH
		static void show_docu(GtkWidget *widget, void *data);
#endif
		static void show_license(GtkWidget *widget, void *data);
		static void config_print_cmd(GtkWidget *widget, void *data);
		static void config_meas_num_font(GtkWidget *widget, void *data);
		static void do_undo(GtkWidget *widget, void *data);
		static void do_redo(GtkWidget *widget, void *data);
		static void select_voice(GtkButton *button, gpointer data);
		static void copy_data(GtkWidget *widget, void *data);
		static void paste_data(GtkWidget *widget, void *data);
		static void delete_block(GtkWidget *widget, void *data);
		static void insert_block(GtkWidget *widget, void *data);
		static void insert_clef(GtkWidget *widget, void *data);
		static void reposit_all(GtkWidget *widget, void *data);
		static void empty_block(GtkWidget *widget, void *data);
		static void spec_meas_test(GtkWidget *widget, void *data);
		static void toggle_insert_erease_mode(GtkAction *action, gpointer data);
		static void set_rest_note_mode(GtkAction *action, gpointer data);
		static void set_dotted_mode(GtkAction *action, gpointer data);
		static void set_ddotted_mode(GtkAction *action, gpointer data);
		static void set_dcross_mode(GtkAction *action, gpointer data);
		static void set_dflat_mode(GtkAction *action, gpointer data);
		static void set_staccato_mode(GtkAction *action, gpointer data);
		static void set_staccatissimo_mode(GtkAction *action, gpointer data);
//		static void set_str_pizz_mode(GtkAction *action, gpointer data);
		static void set_tenuto_mode(GtkAction *action, gpointer data);
		static void set_sforzato_mode(GtkAction *action, gpointer data);
		static void set_sforzando_mode(GtkAction *action, gpointer data);
		static void set_bow_up_mode(GtkAction *action, gpointer data);
		static void set_bow_down_mode(GtkAction *action, gpointer data);
		static void set_pedal_on_mode(GtkAction *action, gpointer data);
		static void set_pedal_off_mode(GtkAction *action, gpointer data);
		static void set_trill_mode(GtkAction *action, gpointer data);
		static void set_prall_mode(GtkAction *action, gpointer data);
		static void set_open_mode(GtkAction *action, gpointer data);
		static void set_mordent_mode(GtkAction *action, gpointer data);
		static void set_fermata_mode(GtkAction *action, gpointer data);
		static void set_arpeggio_mode(GtkAction *action, gpointer data);
		static void set_tied_mode(GtkAction *action, gpointer data);
		static void do_play(GtkAction *action, gpointer data);
		static void set_colored(GtkAction *action, gpointer data);
		static void toggle_shift_mode(GtkAction *action, gpointer data);
		static void set_sharp_mode(GtkAction *action, gpointer data);
		static void set_flat_mode(GtkAction *action, gpointer data);
		static void set_natural_mode(GtkAction *action, gpointer data);
		static void show_graces(GtkAction *action, gpointer data);
		static void show_drum_bar(GtkAction *action, gpointer data);
		static void show_more_accs_bar(GtkAction *action, gpointer data);
		static void set_note_length(GtkAction *action, GtkRadioAction *current, void *data);
		static void set_drum_note(GtkAction *action, GtkRadioAction *current, void *data);
		static void size_change_handler(GtkWidget *widget, GtkRequisition *requisition, gpointer data);
		static gboolean handle_delete(GtkWidget *widget, GdkEvent *event, gpointer data);
		static void handle_page_request(GtkSpinButton *spinbutton, gpointer data);

		void closeApplication();
		void adjustView();
		void setCursor();
		int m_staff_numbers;
		bool m_avoid_feedback;
		bool m_avoid_feedback_action;
		int m_lyrics_mode;

		static gboolean handle_button_press (GtkWidget *widget,
			 GdkEventButton *event, gpointer data);
		static gboolean handle_button_release (GtkWidget *widget,
			 GdkEventButton *event, gpointer data);
		static gboolean key_press_handler (GtkWidget *widget,  GdkEventKey *event,
                                                        gpointer  data);
		static gboolean key_release_handler (GtkWidget *widget,  GdkEventKey *event,
                                                        gpointer  data);
		static gboolean window_leave_handler (GtkWidget *widget,  GdkEventCrossing *event,
                                                        gpointer  data);
		static gboolean window_enter_handler (GtkWidget *widget,  GdkEventCrossing *event,
                                                        gpointer  data);

		static gboolean handle_motion (GtkWidget *widget,
	       			GdkEventMotion *event, gpointer data);

		static void write_png(GtkWidget *widget, void *data);
		static void write_ps(GtkWidget  *widget, void *data);
		static void open_recent(GtkAction *action, gpointer user); 
		double m_pointer_xpos, m_pointer_ypos;
		struct paper_info_struct *m_current_paper;
		bool m_paint_colored;
		bool m_portrait;
		bool m_keyboard_ctrl_mode;
		bool m_draw_postscript;
		int last_full_reposit;
		double m_first_system_indent;
#ifdef YELP_PATH
		char *m_docu;
#endif
		int m_file_version;

	friend class NedAppendNewPageCommand;
	friend class NedInsertNewPageCommand;
	friend class NedChangeMeasureTypeCommand;
	friend class NedChangeMeasureTimeSignatureCommand;
	friend class NedMoveSpecMeasureCommand;
	friend class NedRemoveLastPageCommand;
	friend class NedRemovePageCommand;
	friend class NedSystem;
	friend class NedChangeTimeSigCommand;
	friend class NedMidiExport;
	friend class NedMusicXMLImport;
	friend class NedChangeUpbeadCommand;
	friend class NedInstrumentTable;
};

#endif /* MAINWINDOW_H */
