/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "movespecmeasurecommand.h"
#include "mainwindow.h"

NedMoveSpecMeasureCommand::NedMoveSpecMeasureCommand(NedMainWindow *main_window, int measnum, int dir) :
m_main_window(main_window), m_measnum(measnum), m_dir(dir) {}


void NedMoveSpecMeasureCommand::execute(bool adjust /* = false */) {
	GList *lptr;
#ifdef EXECUTE_DEBUG
	printf("\tNedMoveSpecMeasureCommand::execute\n");
#endif
	for (lptr = g_list_first(m_main_window->m_special_measures); lptr; lptr = g_list_next(lptr)) { // friend !!
		if (((SpecialMeasure *) lptr->data)->measure_number == m_measnum) {
			((SpecialMeasure *) lptr->data)->measure_number += m_dir;
			break;
		}
	}
}


void NedMoveSpecMeasureCommand::unexecute(bool adjust /* = false */) {
	GList *lptr;
#ifdef UNEXECUTE_DEBUG
	printf("\tNedMoveSpecMeasureCommand::unexecute\n");
#endif
	for (lptr = g_list_first(m_main_window->m_special_measures); lptr; lptr = g_list_next(lptr)) { // friend !!
		if (((SpecialMeasure *) lptr->data)->measure_number == m_measnum + m_dir) {
			((SpecialMeasure *) lptr->data)->measure_number -= m_dir;
			break;
		}
	}
}
