/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#include "commandlist.h"
#include "command.h"

NedCommandList::NedCommandList() : m_commands(NULL) {}

NedCommandList::execute(bool adjust /* = false */) {
	GList *lptr;
	for (lptr = g_list_first(m_commands); lptr; lptr = g_list_next(lptr)) {
		if (lptr == g_list_last(m_commands)) {
			((NedCommand*) lptr)->execute(param);
		}
		else {
			((NedCommand*) lptr)->execute();
		}
	}
}

NedCommandList::unexecute(bool adjust /* = false */) {
	GList *lptr;
	for (lptr = g_list_last(m_commands); lptr; lptr = g_list_previous(lptr)) {
		((NedCommand*) lptr)->unexecute();
	}
}

void addCommand(NedCommand *command) {
	m_commands = g_list_append(m_commands, G_POINTER(command));
}
	

