#!/bin/sh

#This script is used clean the source tree,after dpkg-buildpackage -rfakeroot 

#COPYRIGHT (C) YunQiang Su <wzssyqa@gmial.com>,2010.

#PUBILIC UNDER GPLv2 or LATER VERSION GPL.

#rm ./*.log

TOP_DIR=`pwd`
NS3VER=3.13
NS3_DIR=$TOP_DIR/`ls -d ns-*`
PYBINDGENV_DIR=$TOP_DIR/`ls -d pybindgen-0.*`
NSC_DIR=$TOP_DIR/`ls -d nsc-*`
DEBIAN_DIR=$TOP_DIR/debian

echo $DEBIAN_DIR

###############################################
#clean top dir
cd $TOP_DIR
rm .config
rm *.pyc

##############################################
# build waf
cd $DEBIAN_DIR/waf-1.6
./configure
cp waf $NS3_DIR
make distclean
cd $DEBIAN_DIR/waf-1.5
./configure
cp waf $PYBINDGENV_DIR
make distclean

################################################
#clean ns3 dir
cd $NS3_DIR

rm ./doc/introspected-doxygen.h
rm ./doc/ns3-object.txt
rm -rf ./doc/html
rm -rf ./doc/latex

make clean -C ./doc/manual
make clean -C ./doc/tutorial
make clean -C ./doc/models

rm ./different.pcap

./waf clean
./waf distclean

./bindings/python/waf clean
./bindings/python/waf distclean

rm -rf ./build
find . -name '*.pyc' -exec rm {} \;
find . -name '.waf-*' -exec rm -rf {} \;
rm waf

cd $PYBINDGENV_DIR
find . -name '*.pyc' -exec rm {} \;
find . -name '.waf-*' -exec rm -rf {} \;
rm waf

cd $NSC_DIR
./scons.py -c
rm linux-2.6.18/include/asm
rm linux-2.6.26/include/asm
rm ./config.log
find . -name '*.pyc' -exec rm {} \;
find . -name '.waf-*' -exec rm -rf {} \;
rm -rf .sconf_temp
rm .sconsign.dblite

exit 0
