/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: time.c,v 1.9 2008-02-23 08:35:04 anton Exp $ */

#include "netams.h"

#ifdef USE_TICKS

#include "cycle.h"

#define 	TIME_TILL_SYNC		60000000
/////////////////////////////////////////////////////////////////////////////////////////
double		tick_rate;
ticks		zero_tick;
struct timeval  zero_time;

int set_zero_time(struct timezone *tzp);
time_t netams_time(time_t *t);
int netams_gettimeofday(struct timeval *tv, struct timezone *tzp);
/////////////////////////////////////////////////////////////////////////////////////////
//find out proportion for processor ticks <-> microsecond
/////////////////////////////////////////////////////////////////////////////////////////
void CalibrateClock() {
	struct timeval start;
	struct timeval stop;

	ticks t1, t2;
	double diff;
	double min      = 1e60;
	double max      = 0;
	double avg      = 0;

	unsigned difft;
	u_char j;
	register unsigned i;

	for(j=0; j < 12; j++) {
		t1=getticks();
		gettimeofday(&start, NULL);

		for(i=0;i<0xFFFFFFF; i++);
		t2 = getticks();
		gettimeofday(&stop, NULL);
		diff = elapsed(t2, t1);

		difft= (unsigned) ( (stop.tv_sec - start.tv_sec)*1000000 + (stop.tv_usec - start.tv_usec));

		tick_rate = diff/difft;

		if(min > diff) min = tick_rate;
		if(max < diff) max = tick_rate;
		avg+= tick_rate;
//              printf("%lf %lf %u\n", tick_rate,  diff, difft);
	}

	tick_rate = (avg - min -max)/10; //calculate average multiplier, except min and max
	aLog(D_INFO, "Calibrating ticks: %lf ticks per microsecond\n", tick_rate);
	aLog(D_INFO, "Time <-> ticks will be resynced every %u seconds\n",
		(unsigned)(TIME_TILL_SYNC/1000000));

	set_zero_time(NULL);	
}
/////////////////////////////////////////////////////////////////////////////////////////
int netams_gettimeofday(struct timeval *tv, struct timezone *tzp) {
	int ret 	= 0;
	unsigned diff	= (unsigned)(elapsed( getticks(), zero_tick)/tick_rate);
	
	if (diff > TIME_TILL_SYNC) {
		ret		 = set_zero_time(tzp);
		bcopy(&zero_time, tv, sizeof(struct timeval));
	} else {
		bcopy(&zero_time, tv, sizeof(struct timeval));
		
		tv->tv_usec	+= diff;
		tv->tv_sec 	+= (long)(tv->tv_usec / 1000000);
		
		tv->tv_usec 	 = (long)(tv->tv_usec % 1000000);
	}
	return ret;
}

time_t netams_time(time_t *t) {
	
	time_t tt;
	
	unsigned diff   = (unsigned)(elapsed( getticks(), zero_tick)/tick_rate);

	if (diff > TIME_TILL_SYNC) {
		set_zero_time(NULL);
		tt = (time_t)zero_time.tv_sec;
	} else {
		tt = (time_t)(zero_time.tv_sec + diff / 1000000);
	}
		
	if(t) *t = tt;
	
	return tt;
}

int set_zero_time(struct timezone *tzp) {
	zero_tick	= getticks();
	return gettimeofday(&zero_time, tzp);
}

#else

void CalibrateClock() {}

time_t netams_time(time_t *t) {
	return time(t);
}

int netams_gettimeofday(struct timeval *tv, struct timezone *tzp) {
	return gettimeofday(tv, tzp);
}

#endif
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
