/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: s_html.c,v 1.87 2009-08-01 09:23:55 anton Exp $ */

#include "netams.h"

Service_Html *Html=NULL;
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
Service_Html::Service_Html():Service(SERVICE_HTML) {
	path=NULL;
	run_period=NULL;
	is_distributed=0;
	cpages=CPAGES_ALL;
	apages=APAGES_NONE;
	url=NULL;
	servlet_url=NULL;
	is_htaccess=0;
	is_graphs=0;
	grouproot=NULL;
	display_top=0;
	display_health=0;
	
	Html=this;
}

Service_Html::~Service_Html() {
	if(path) aFree(path);
	if(run_period) aFree(run_period);
	if(url) aFree(url);
	if(servlet_url) aFree(servlet_url);
}
//////////////////////////////////////////////////////////////////////////////////////////
int Service_Html::ProcessCfg(struct cli_def *cli, char **param, int argc, u_char no_flag){

	if (STRARG(param[0], "path")) {
		if(path) aFree(path);
		path=set_string(param[1]);
		cli_error(cli, "html path is set to %s", path);
	}
	else if (STRARG(param[0], "url")) {
		if(url) aFree(url);
		url=set_string(param[1]);
		cli_error(cli, "URL path is set to %s", url);
	}
	else if (STRARG(param[0], "servlet-url")) {
		if(servlet_url) aFree(servlet_url);
		servlet_url=set_string(param[1]);
		cli_error(cli, "Servlet URL path is set to %s", servlet_url);
	}
	else if (STRARG(param[0], "run")) {
		if(run_period) aFree(run_period);
		run_period=set_string(param[1]);
		cli_error(cli, "html run period is set to %s", run_period);
		if (STREQ(param[1], "distributed")) {
			is_distributed=1;
			cli_error(cli, "html service will run in distributed mode");
		}
	}
	else if (STREQ(param[0], "htaccess")) {
		if (STREQ(param[1], "yes") || strtol(param[1], NULL, 10)==1) {
			cli_error(cli, "html service will manage Apache .htaccess and .htpasswd files");
			is_htaccess=1;
		}
		else if (STREQ(param[1], "radius") || strtol(param[1], NULL, 10)==2) {
			cli_error(cli, "html service will manage Apache .htaccess and ask RADIUS for passwords");
			is_htaccess=2;
		}
		else {
			cli_error(cli, "html service will NOT manage Apache .htaccess and .htpasswd files");
			is_htaccess=0;
		}
	}
	else if (STREQ(param[0], "graphs")) {
		if (STREQ(param[1], "yes") || strtol(param[1], NULL, 10)==1) {
			cli_error(cli, "html service will create references to dynamic graphs");
			is_graphs=1;
		}
		else {
			cli_error(cli, "html service will NOT create references to dynamic graphs");
			is_graphs=0;
		}
	}
	else if (STREQ(param[0], "client-pages")) {
		if (STREQ(param[1], "all")) {
			cpages=CPAGES_ALL;
			cli_error(cli, "html client pages creator: all pages");
		}
		else if (STREQ(param[1], "groups")) {
			cpages=CPAGES_GROUPS;
			cli_error(cli, "html client pages creator: only group units");
		}
		else if (STREQ(param[1], "group")) {
			cpages=CPAGES_GROUPLIST;
			Html_grouplist_item *gr1 = grouproot, *gr2=NULL;
			while (gr1) { gr2=gr1->next; aFree(gr1); gr1=gr2; } 
			grouproot=gr1=NULL;
			cli_error(cli, "html client pages creator: members of specified groups:");
			
			NetUnit *u;
			for (int i=2; i<argc; i++ ) {
				if ((u=Units->getUnit(param[i])) && u->type==NETUNIT_GROUP) {
					gr1=(Html_grouplist_item*)aMalloc(sizeof (Html_grouplist_item));
					gr1->groupid=u->id;
					cli_error(cli, "\t\tgroup: %s, oid=%06X", param[i], u->id);
					if (grouproot==NULL) grouproot=gr1; else gr2->next=gr1;
					gr2=gr1;
				}
			}
		}
		else if (STREQ(param[1], "none")) {
			cpages=CPAGES_NONE;
			cli_error(cli, "html client pages creator: none created");
		}
	}
	else if (STREQ(param[0], "account-pages")) {
		if (STREQ(param[1], "all")) {
			apages=APAGES_ALL;
			cli_error(cli, "html account pages creator: all pages");
		}
		else if (STREQ(param[1], "none")) {
			apages=APAGES_NONE;
			cli_error(cli, "html account pages creator: none created");
		}
	}
	else if (STRARG(param[0], "display-top")) {
		display_top=strtol(param[1], NULL, 10);
		if (display_top) 
			cli_error(cli, "html will create 'TOP %d' pages", display_top);
		else 
			cli_error(cli, "html will NOT create 'TOP xx' pages");
	}
	else if (STRARG(param[0], "display-health")) {
		if (STREQ(param[1], "yes") || strtol(param[1], NULL, 10)==1)
			display_health=1;
		else
			display_health=0;
		cli_error(cli, "html will %sdisplay system health", display_health?"":"NOT ");
	}
	return CLI_OK;
}
//////////////////////////////////////////////////////////////////////////////////////////
void Service_Html::ShowCfg(struct cli_def *cli, u_char flags){
	if (path) cli_print(cli, "path %s", path);
	if (run_period) cli_print(cli, "run %s", run_period);
	if (url) cli_print(cli, "url %s", url);
	if (servlet_url) cli_print(cli, "servlet-url %s", servlet_url);
	if (is_htaccess==1) cli_print(cli, "htaccess yes");
	else if (is_htaccess==2) cli_print(cli, "htaccess radius");

	if (cpages==CPAGES_ALL) cli_print(cli, "client-pages all");
	else if (cpages==CPAGES_GROUPS) cli_print(cli, "client-pages groups");
	else if (cpages==CPAGES_NONE) cli_print(cli, "client-pages none");
	else if (cpages==CPAGES_GROUPLIST && grouproot) {
		cli_bufprint(cli, "client-pages group");
		NetUnit *u=NULL;
		for (Html_grouplist_item *item=grouproot; item!=NULL; item=item->next) {
			if ((u=(NetUnit*)Units->getById(item->groupid)) && u->name)
				cli_bufprint(cli, " %s", u->name);
		}
		cli_bufprint(cli, "\n");
	}
	if (display_top) cli_print(cli, "display-top %u", display_top);
	if (display_health==1) cli_print(cli, "display-health yes");
	if (is_graphs==1) cli_print(cli, "graphs yes");
	
#ifdef HAVE_BILLING
	if (apages==APAGES_ALL) cli_print(cli, "account-pages all");
	else if (apages==APAGES_NONE) cli_print(cli, "account-pages none");
#endif
}
//////////////////////////////////////////////////////////////////////////////////////////
void Service_Html::Worker(){
	// here we should put scheduler task setup code
	if (!run_period) aLog(D_WARN, "cannot set up scheduler task because no run period defined\n");
	else if (is_distributed) {
		aLog(D_DEBUG, "distributing html service...\n");
		while (1) {
			Sleep(300);

			//cancellation disabled here
			sHtmlAction(this);
		}
		return;
	} else {
		char buffer[256];
		sprintf(buffer, "schedule oid 08FFFF action html time %s", run_period);
		// snprintf(buffer, 256, "schedule action \"html\" time %s invisible", run_period);
		aCommand(buffer, MODE_EXEC, LOGFILE);
	}

	// here we should put path checking and directories creation

	while(1) {
		Sleep(); // we will wait for external wakeup signal from scheduler initiated call

		//cancellation disabled here
		// actual action
		aLog(D_INFO, "html pages creation...\n");
		sHtmlAction(this);
		aLog(D_INFO, "html pages created\n");
	}
}
//////////////////////////////////////////////////////////////////////////////////////////
void Service_Html::Cancel(){
	// aCommand("no schedule oid 08FFFF", MODE_EXEC, LOGFILE);
	// noted by Flanker
	// see http://www.netams.com/ubb/cgi-bin/ultimatebb.cgi?ubb=get_topic&f=2&t=002903
	Html=NULL;
}
//////////////////////////////////////////////////////////////////////////////////////////
int cHtml(struct cli_def *cli, const char *cmd, char **argv, int argc){
	// regardless of command parameters, wake up the html service
	if (Html) Html->Wakeup();
	else cli_error(cli, "html command while no html service running\n");
	return CLI_OK;
}
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
