/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: net_units.h,v 1.109 2009-08-01 09:23:54 anton Exp $ */

#define NETUNIT_TYPES_NUM	6

enum netunit_type { NETUNIT_UNKNOWN=0, NETUNIT_USER=1, NETUNIT_HOST=2, NETUNIT_CLUSTER=3, NETUNIT_NET=4, NETUNIT_GROUP=5 };
extern const char *netunit_type_name[NETUNIT_TYPES_NUM];

//flags for netunit
#define NETUNIT_CHANGED		0x01	//unit is changed
#define NETUNIT_NLP		0x02	//no-local-pass 
#define NETUNIT_BROKEN_FW_MF	0x04	//fw check for this unit might be broken
#define NETUNIT_BROKEN_ACCT_MF	0x08	//acct check for this unit might be broken
#define NETUNIT_POLICY_TARGET	0x10	//this unit used as policy target
#define NETUNIT_BACKUP_FW	0x20	//this unit used as last resort fw check
#define NETUNIT_AP_NODEFAULT	0x40	//default accounting policies will not be used
#define NETUNIT_FP_NODEFAULT	0x80	//default filtering policies will not be used

void DSListAdd(NetUnit *u, u_char *i, struct cli_def *cli, char *param[], u_char no_flag);
/////////////////////////////////////////////////////////////////////////////////////
class NetUnit_group;	
class Attribute;

class NetUnit: public Object {
	public:
		char *name;
		char *description;
		char *email;
		char *password;

		netunit_type type;


		Attribute **attrlist; //attributes ELIST
		NetUnit_group **parents; //ELIST
		
		PdList *ap;
		PdList *fp;
		
		u_char **dslist;
		
		Service **monitors;	//monitor to

		sLoginData *logindata;
		sQuotaData *quotadata;
		
		BWinfo *bwi;
#ifdef HAVE_BILLING
		Account *account;
#endif

		SysPolicy sys_policy; 
		oid sys_policy_perm;
		u_char flags;
		
		NetUnit(netunit_type t);
		virtual ~NetUnit();

		void setDSList(u_char ds_id);
		void clearDSList(u_char ds_id=0);
		int checkDSList(u_char ds_id); 
		
		void setName(char *n);
		match Check(Flow *list);

		virtual match Check(in_addr src, in_addr dst) { return MATCH_NONE;};
		virtual int unit2ds(Service *ds, u_char action) {return 1;}; // flag=1 add 0 -remove
		
		void unit2trees(u_char flag); //add unit to all correspondign trees
		void SetSysPolicy(SysPolicy sp, u_char flag, time_t now=time(NULL)); // flag=1 add 0 -remove
		void ShowConfig(struct cli_def *cli, u_char flags);
};

/////////////////////////////////////////////////////////////////////////////////////
class NetUnit_host: public NetUnit {
	public:
		struct in_addr ip;
		struct ether_addr *mac;
		NetUnit_host();
		~NetUnit_host();
		match Check(in_addr src, in_addr dst);
		int unit2ds(Service *ds,u_char flag);
};

class NetUnit_net: public NetUnit {
	public:
		struct in_addr ip;
		struct in_addr mask;
		NetUnit_net *next;
		u_char auto_units_id;
		NetUnit_net();
		match Check(in_addr src, in_addr dst);
		int unit2ds(Service *ds, u_char flag);
	};

class NetUnit_cluster: public NetUnit {
	private:
		unsigned references;
		pthread_rwlock_t rwlock;
	public:
		NetUnit_net *root;
		NetUnit_cluster();
		~NetUnit_cluster();
		void Add(struct in_addr ip, struct in_addr mask);
		void Remove(struct in_addr ip, struct in_addr mask);
		match Check(in_addr src, in_addr dst);
		int unit2ds(Service *ds, u_char flag);
	};

class NetUnit_group: public NetUnit {
	public:
		unsigned references;
		NetUnit **childrens; //this is extarnal list
		
		u_char level;

		NetUnit_group();
		~NetUnit_group();
		match Check(in_addr src, in_addr dst);
		void SetGroupWeights(NetUnit_group *u, u_char weight);
	};

class NetUnit_user: public NetUnit {
	public:
        struct in_addr ip;
		struct ether_addr *mac;
        NetUnit_user();
		~NetUnit_user();
		match Check(in_addr src, in_addr dst);
		int unit2ds(Service *ds, u_char flag);
        };
/////////////////////////////////////////////////////////////////////////////////////
class NetUnitsList: public List {
	public:
		NetUnitsList();
		~NetUnitsList();
	
		NetUnit_group **groups;	//ELIST

		void SortGroups();
		void Unit2Group(NetUnit *u, NetUnit_group *g, u_char action);
		
		int Insert(NetUnit *u);
		int Delete(NetUnit *u);

		NetUnit *getUnit(char *name);
		NetUnit *getUnitByIP(in_addr_t s);
		void DeletePolicyElsewhere(Policy *p);
		void listPasswordsHtml(FILE *f);
		void ShowConfig(struct cli_def *cli, u_char flags);
};
/////////////////////////////////////////////////////////////////////////////////////
int cUnit(struct cli_def *cli, char **param, int argc, u_char no_flag);
NetUnit* aParseUnit(char *param[], u_char *pos, oid *uid=NULL);
void sPConstructStoreOidMessage(NetUnit *u, Policy *p=NULL);
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
