/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: list.h,v 1.16 2009-08-01 09:23:55 anton Exp $ */

/////////////////////////////////////////////////////////////////////////////////////
class Object {
	public:
		oid id;
		Object *next;

		Object() { next=NULL; id=0; };
		virtual ~Object() {};
};


class List {
	public:
		Object *root, *last;
		unsigned num_objects;
		pthread_rwlock_t rwlock;

		Object get;

#ifndef WIPE_OPENSSL
		LHASH *hash;
#else
		GHashTable *hash;
#endif

		List(u_char init_hash=1);
		~List();

		int Insert(Object *obj);
		int Delete(Object *obj);
		
		Object* getById(oid id);

		unsigned getNum() { return num_objects; };
};
/////////////////////////////////////////////////////////////////////////////////////
// external list functionality
#define ELIST_ADD(table, obj)		_elist_add((void***)&table, (void*)obj) 
#define ELIST_REMOVE(table, obj)	_elist_remove((void**)table, (void*)obj)
#define ELIST_SEARCH(table, obj)	_elist_search((void**)table, (void*)obj)
#define ELIST_IS_EMPTY(table)		(!table || table[0]==NULL)
#define ELIST_INIT(table)			table=NULL
#define ELIST_FREE(table) \
	if(table){\
		aFree(table);\
		table=NULL;\
	}

#define ELIST_FOR_EACH(table, arg) \
		if(!table); else\
			for(unsigned ecounter=0;\
			(arg=table[ecounter]) && arg!=(void*)table;\
			ecounter++)

void  _elist_add(void ***table, void *obj);
void  _elist_remove(void **table, void *obj);
void* _elist_search(void **table, void *obj);
/////////////////////////////////////////////////////////////////////////////////////
