#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <limits.h>

#include <NASPRO/core/lib.h>

static int test_res = EXIT_SUCCESS;
static const char *test_name;

static void
test_begin(const char *name)
{
	test_name = name;
	printf("[Beginning of the %s test]\n", test_name);
}

static void
test_end()
{
	printf("[End of the %s test]\n", test_name);
	exit(test_res);
}

static void
test_msg(const char *fmt, ...)
{
	va_list ap;

	printf("  ");

	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);

	printf("\n");
}

static void
test_err(const char *fmt, ...)
{
	va_list ap;

	printf("    error: ");

	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);

	printf("\n");

	test_res = EXIT_FAILURE;
}
