/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2011 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#define _WIN32_WINNT	0x501
#define UNICODE

#include "internal.h"

#include <windows.h>

const char *
nacore_env_get(const char *name)
{
	const char buf[32767 * 2];
	const char *ret;
	char *namew;
	DWORD err;

	namew = nacore_string_utf8_to_utf16le_a(name);
	if (namew == NULL)
	  {
		errno = ENOMEM;
		return NULL;
	  }

	err = GetEnvironmentVariableW((LPCWSTR)namew, (LPWSTR)buf, 32767);
	free(namew);
	if (err == 0)
	  {
		errno = (GetLastError() == ERROR_ENVVAR_NOT_FOUND)
			? ENOENT : NACORE_EUNKNOWN;
		return NULL;
	  }

	ret = nacore_string_utf16le_to_utf8_a(buf);
	if (ret == NULL)
	  {
		errno = ENOMEM;
		return NULL;
	  }

	return ret;
}

void
nacore_env_free(const char *value)
{
	free((void *)value);
}

_NACORE_DEF nacore_list
nacore_env_path_prefixes_split(const char *path)
{
	return nacore_string_split(path, ";", NULL, NULL);
}
