--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with McKae.XML.EZ_Out.String_Stream;
function Error_Message (Cmd : String;
                        Severity : String;
                        Message : String)
                       return String is
   use McKae.XML.EZ_Out.String_Stream.String_Buffering;
   use McKae.XML.EZ_Out.String_Stream.XML_String_Buffer;
   Xml_Buffer : String_Buffer;
begin
   Clear (Xml_Buffer);
   Start_Element (Xml_Buffer, "result", ("cmd" = Cmd, "status" = "ERROR"));
   Start_Element (Xml_Buffer, "message", "type" = "standard");
   Output_Element (Xml_Buffer, "severity", Severity);
   Output_Element (Xml_Buffer, "text", Message);
   End_Element (Xml_Buffer, "message");
   End_Element (Xml_Buffer, "result");
   declare
      String_To_Return : constant String := Get_String (Xml_Buffer);
   begin
      Full_Clear (Xml_Buffer);
      return String_To_Return;
   end;
end Error_Message;
