/*
 * Decompiled with CFR 0.152.
 */
package old_logformat.slog2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import old_base.drawable.TimeBoundingBox;
import old_logformat.slog2.FileBlockPtr;

public class TreeDirValue {
    public static final int BYTESIZE = 28;
    private TimeBoundingBox timebounds;
    private FileBlockPtr blockptr;

    public TreeDirValue(TimeBoundingBox timeBoundingBox, FileBlockPtr fileBlockPtr) {
        this.timebounds = timeBoundingBox;
        this.blockptr = fileBlockPtr;
    }

    public double getEarliestTime() {
        return this.timebounds.getEarliestTime();
    }

    public double getLatestTime() {
        return this.timebounds.getLatestTime();
    }

    public TimeBoundingBox getTimeBoundingBox() {
        return this.timebounds;
    }

    public long getFilePointer() {
        return this.blockptr.getFilePointer();
    }

    public int getBlockSize() {
        return this.blockptr.getBlockSize();
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        this.timebounds.writeObject(dataOutput);
        this.blockptr.writeObject(dataOutput);
    }

    public TreeDirValue(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.timebounds = new TimeBoundingBox(dataInput);
        this.blockptr = new FileBlockPtr(dataInput);
    }

    public String toString() {
        return "DirVal[ " + this.timebounds + ", " + this.blockptr + " ]";
    }
}

