/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import viewer.common.Dialogs;
import viewer.common.TopControl;
import viewer.common.TopWindow;
import viewer.first.FirstMenuBar;
import viewer.first.FirstPanel;
import viewer.zoomable.Debug;
import viewer.zoomable.Profile;

public class FirstFrame
extends JFrame
implements TopControl {
    private static final long serialVersionUID = 14300L;
    private static boolean isApplet = false;
    private static String filename = null;
    private static int view_ID = -1;
    private FirstPanel top_panel;
    private FirstMenuBar top_menubar;
    private static String help_msg = "Usage: java timelines.MainFrame [options] [slog2_filename]\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n\t [-debug]                          \t Turn on Debugging output\n\t [-profile]                        \t Turn on Profiling output\n\t [-v view_ID ]                     \t Default value is -1.\n";

    public FirstFrame() {
        super("Jumpshot-4");
        super.setDefaultCloseOperation(0);
        TopWindow.First.setWindow(this);
        this.top_panel = new FirstPanel(isApplet, filename, view_ID);
        super.setContentPane(this.top_panel);
        this.top_menubar = new FirstMenuBar(isApplet, this.top_panel);
        super.setJMenuBar(this.top_menubar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (Dialogs.confirm(TopWindow.First.getWindow(), "Are you sure you want to exit Jumpshot-4 ?")) {
                    TopWindow.First.disposeAll();
                }
            }
        });
    }

    public void init() {
        this.top_panel.init();
    }

    public void setEditPreferenceButtonEnabled(boolean bl) {
        this.top_panel.getEditPreferenceButton().setEnabled(bl);
    }

    public void setShowLegendButtonEnabled(boolean bl) {
        this.top_panel.getShowLegendButton().setEnabled(bl);
    }

    public void setShowTimelineButtonEnabled(boolean bl) {
        this.top_panel.getShowTimelineButton().setEnabled(bl);
    }

    public static void checkVersion() {
        String string = System.getProperty("java.version");
        System.out.println("Java is version " + string + ".");
        if (string.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + string + ". \n" + "\t It is too old to run this viewer.");
        }
    }

    public static void main(String[] stringArray) {
        FirstFrame.checkVersion();
        FirstFrame.parseCmdLineArgs(stringArray);
        Debug.initTextArea();
        System.out.println("Starting the SLOG-2 Display Program ..... ");
        FirstFrame firstFrame = new FirstFrame();
        firstFrame.pack();
        TopWindow.layoutIdealLocations();
        firstFrame.setVisible(true);
        firstFrame.init();
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-v")) {
                        String string = stringArray[++n];
                        view_ID = Integer.parseInt(string);
                        stringBuffer.append("\n view_ID = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-debug")) {
                        Debug.setActive(true);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-profile")) {
                        Profile.setActive(true);
                        ++n;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + FirstFrame.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + FirstFrame.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }
}

