// Copyright 2010-2012, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef MOZC_DICTIONARY_DICTIONARY_IMPL_H_
#define MOZC_DICTIONARY_DICTIONARY_IMPL_H_

#include <vector>
#include "base/base.h"
#include "dictionary/dictionary_interface.h"

namespace mozc {

class SuppressionDictionary;
class SystemDictionary;
class ValueDictionary;

class DictionaryImpl : public DictionaryInterface {
 public:
  virtual ~DictionaryImpl();

  virtual Node *LookupPredictiveWithLimit(
      const char *str, int size, const Limit &limit,
      NodeAllocatorInterface *allocator) const;

  virtual Node *LookupPredictive(const char *str, int size,
                                 NodeAllocatorInterface *allocator) const;

  virtual Node *LookupPrefixWithLimit(
      const char *str, int size,
      const Limit &limit,
      NodeAllocatorInterface *allocator) const;

  virtual Node *LookupPrefix(
      const char *str, int size,
      NodeAllocatorInterface *allocator) const;

  virtual Node *LookupReverse(const char *str, int size,
                              NodeAllocatorInterface *allocator) const;

  virtual bool Reload();

  virtual void PopulateReverseLookupCache(
      const char *str, int size, NodeAllocatorInterface *allocator) const;

  virtual void ClearReverseLookupCache(NodeAllocatorInterface *allocator) const;

 protected:
  DictionaryImpl(const char *dic_data, int dic_data_size);

 private:
  vector<DictionaryInterface *> dics_;
  SuppressionDictionary *suppression_dictionary_;
  scoped_ptr<SystemDictionary> system_dictionary_;
  scoped_ptr<ValueDictionary> value_dictionary_;

  enum LookupType {
    PREDICTIVE,
    PREFIX,
    REVERSE,
  };

  Node *LookupInternal(const char *str, int size,
                       LookupType type,
                       const Limit &limit,
                       NodeAllocatorInterface *allocator) const;

  Node *MaybeRemoveSpecialNodes(Node *node) const;
};

}  // namespace mozc

#endif  // MOZC_DICTIONARY_DICTIONARY_IMPL_H_
