#############################################################################
# mined text editor make actions (make include file for make targets)
# Mouse library (optional, empty for most architectures)


#############################################################################
# make target parameters to be set before including this:
# (could be set to default with the ?= syntax but that doesn't work 
# in all versions of make)

# MOUSELIB ?= 
# SCREENOBJ ?= io.o keyboard.o
# KEYMAPSDEP ?= keymaps/_keymaps.h


#############################################################################
# components to be compiled

# Mined modules
OBJS =	mined1.o edit.o pastebuf.o textfile.o textbuf.o justify.o search.o \
	minedaux.o \
	output.o prompt.o compose.o \
	$(CHARMAPS) charcode.o \
	mousemen.o \
	keymaps.o keydefs.o dispatch.o handescr.o \
	termprop.o width.o encoding.o \


#############################################################################
# commands
#WGET=curl -R -O --connect-timeout 5
WGET=wget -N -t 1 --timeout=5


#############################################################################
# target properties, default target, auxiliary targets

# functional or abbreviated (non-file) targets:
.PHONY:	mkcharmaps mkkeymaps mnemodoc help man bin install localinstall optinstall links clean clear debianclean update all unidata vni viqr vtelex

# Default make target:
all:	$(MAKEMAPS) mined


#############################################################################
# Unicode data tables:

UnicodeData.txt:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/UnicodeData.txt

Scripts.txt:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/Scripts.txt

Blocks.txt:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/Blocks.txt

SpecialCasing.txt:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/SpecialCasing.txt

PropList.txt:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/PropList.txt

EastAsianWidth.txt:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/EastAsianWidth.txt

Unihan.zip:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/Unihan.zip

Unihan.txt:
	$(MAKE) -f mkinclud.mak Unihan.zip
	unzip -o Unihan.zip
	touch -r Unihan.txt Unihan.zip

UCD.html:
	echo Trying to retrieve Unicode data description via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/UCD.html

BIG5.TXT:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT

unidata:	UnicodeData.txt SpecialCasing.txt Scripts.txt Unihan.txt PropList.txt UCD.html
	rm -f casetabl.t casespec.t softdot.t combin.t
	rm -f scripts.t charname.t categors.sed categors.t
	rm -f UniWITH
	echo Not removing handescr.t because it takes a little while to rebuild.
	echo Remove or rename manually to have it rebuilt!
	echo Also remove handescr/descriptions.uni!
	echo Not removing keymaps?/Radical_Stroke.h because it takes very long to rebuild.
	echo Remove or rename manually to have it rebuilt, then move from keymaps/ into keymaps0/ !
	# rm -f handescr.t handescr/descriptions.uni
	# rm -f keymaps?/Radical_Stroke.h
	#./mkcasetb
	#./mkcasesp
	#CC=$(CC) ./mkscript

uniset.tar.gz:
	$(WGET) http://www.cl.cam.ac.uk/~mgk25/download/uniset.tar.gz

#WIDTH-A:	uniset.tar.gz
#	tar xvzf uniset.tar.gz WIDTH-A

WIDTH-A:	EastAsianWidth.txt
	./mkwidthA

widthdata:	iscombin.new iswide.new

univer = `sed -e '/^\# Blocks-/ s,[^0-9],,g' -e t -e d Blocks.txt`
univer_prev = `sed -e '/^\# Blocks-/ s,[^0-9],,g' -e t -e d unicode-previous/Blocks.txt`

# (Blocks.txt is a dummy dependency of uniset)
iscombin.new:	UnicodeData.txt Blocks.txt
	echo "static struct interval" > iscombin.new
	echo "combining_$(univer) [] =" >> iscombin.new
	uniset +cat=Me +cat=Mn +cat=Cf -00AD +1160-11FF +200B c >> iscombin.new

# (Blocks.txt is a dummy dependency of uniset)
iswide.new:	UnicodeData.txt Blocks.txt # WIDTH-A
	echo "static struct interval" > iswide.new
	echo "ambiguous_$(univer) [] =" >> iswide.new
	uniset +WIDTH-A -cat=Me -cat=Mn -cat=Cf c >> iswide.new

iscombin.old:	UnicodeData.txt unicode-previous/Blocks.txt
	echo "static struct interval" > unicode-previous/iscombin.old
	echo "combining_$(univer_prev) [] =" >> unicode-previous/iscombin.old
	cd unicode-previous; uniset +cat=Me +cat=Mn +cat=Cf -00AD +1160-11FF +200B c >> iscombin.old
	mv unicode-previous/iscombin.old ./

iswide.old:	UnicodeData.txt unicode-previous/Blocks.txt # unicode-previous/WIDTH-A
	echo "static struct interval" > unicode-previous/iswide.old
	echo "ambiguous_$(univer_prev) [] =" >> unicode-previous/iswide.old
	cd unicode-previous; uniset +WIDTH-A -cat=Me -cat=Mn -cat=Cf c >> iswide.old
	mv unicode-previous/iswide.old ./

widthdiff:	iscombin.add iswide.add

#unicode-update:
#	mkdir unicode-update

iscombin.add:	iscombin.new iscombin.old
	./tabrange iscombin.new > iscombin.new.range
	./tabrange iscombin.old > iscombin.old.range
	uniset +iscombin.new.range -iscombin.old.range table > iscombin.add
	rm -f iscombin.new.range iscombin.old.range

iswide.add:	iswide.new iswide.old
	./tabrange iswide.new > iswide.new.range
	./tabrange iswide.old > iswide.old.range
	uniset +iswide.new.range -iswide.old.range table > iswide.add
	rm -f iswide.new.range iswide.old.range

# not needed directly for current Unicode version; 
# same range of characters as listed in scripts.t
assigned.t:	UnicodeData.txt Blocks.txt
	uniset +0000-10FFFF clean c > assigned.t

u/full-unicode.txt:	UnicodeData.txt Blocks.txt
	(uniset +0000-FFFF utf8-list ; uniset +10000..10FFFF clean utf8-list) > u/full-unicode.txt

cjk-b5.h:	mkbig5map # Unihan.txt BIG5.TXT
	./mkbig5map

# Vietnamese input methods:

UniWITH:	UnicodeData.txt
	sed -e "s,^\([^;]*\);\([^;]* LETTER [^;]* WITH [^;]*\);.*,U+\1	\2 AND," -e t -e d UnicodeData.txt | ./insutf8 > UniWITH

vni:	keymaps/VNI.h

categors.sed:	mkcategs # UCD.html
	./mkcategs -sed

categors.t:	mkcategs # UCD.html
	./mkcategs -h

keymaps/VNI.h:	UniWITH vni.sev vni.sed vni.seh
	mkdir -p keymaps
	(sed -f vni.sev UniWITH ; cat UniWITH) | LC_ALL=C sed -f vni.sed | sed -f vni.seh > keymaps/VNI.h

viqr:	keymaps/VIQR.h

keymaps/VIQR.h:	keymaps/VNI.h
	mkdir -p keymaps
	sed -e "s,VNI,VIQR," keymaps/VNI.h | tr "6879125340" "^(+d\'\`.?~-" > keymaps/VIQR.h

vtelex:	keymaps/Vtelex.h

keymaps/Vtelex.h:	keymaps/VNI.h
	mkdir -p keymaps
	sed -e "s,VNI,Vtelex," -e "s,\([Aa]\)6,\1a," -e "s,\([Ee]\)6,\1e," -e "s,\([Oo]\)6,\1o," keymaps/VNI.h | tr "879125340" "wwdsfjrxz" > keymaps/Vtelex.h

# Case conversion tables:

casetabl.t:	mkcasetb # UnicodeData.txt
	./mkcasetb

casespec.t:	mkcasesp # SpecialCasing.txt
	./mkcasesp

# Unicode character information tables:
softdot.t:	mkpropl # PropList.txt
	./mkpropl Soft_Dotted > softdot.t

combin.t:	mkcombin # UnicodeData.txt
	CC=$(CC) ./mkcombin

charprop.t:	mkpropl # PropList.txt
	./mkpropl Quotation_Mark > charprop.t
	./mkpropl Dash >> charprop.t

scripts.t:	mkscript categors.sed # Scripts.txt
	CC=$(CC) ./mkscript

charname.t:	mkchname # UnicodeData.txt
	CC=$(CC) ./mkchname

decompos.t:	mkdecompose # UnicodeData.txt
	CC=$(CC) ./mkdecompose

# from:		Greek		124 64
# generate:		{"Greek", 124, 64},
colours.t:	colours.cfg # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Z][A-Za-z_]*\)[ 	,"]*\([0-9][0-9]*\)[	 ][	 ]*\([0-9][0-9]*\).*/	{"\1", \2, \3},/' -e t -e 's/^[ 	"]*\([A-Z][A-Za-z_]*\)[ 	,"]*\([0-9][0-9]*\).*/	{"\1", \2, -1},/' -e t -e d colours.cfg | sort > colours.t

# Unihan database dependent information:
unihan:	handescr.t radical_stroke # cjk-b5.h is deprecated
	echo "mkkbmap Cangjie [+]"

# Unihan character description table:
handescr.t:	# handescr/descriptions.uni Unihan.txt
	cd handescr && $(MAKE) descriptions.h
	ln handescr/descriptions.h handescr.t || cp handescr/descriptions.h handescr.t

# Radical/Stroke input method table:
radical_stroke:	keymaps/Radical_Stroke.h

keymaps/Radical_Stroke.h:	# Unihan.txt
	cd handescr && $(MAKE) Radical_Stroke.h
	ln handescr/Radical_Stroke.h keymaps/ || cp handescr/Radical_Stroke.h keymaps/

# Radical/Stroke input method table:
cangjie:	keymaps/Cangjie.h

keymaps/Cangjie.h:	# Unihan.txt etc/charmaps/hkscs/hkscs-2004-cj.txt
	./mkkbmap cj +

# Keyboard mapping table configuration:

# source lines: Greek	GreekMonotonic	gr	(Y)
# check input method tag ("gr", ...) for uniqueness
getkeymapstags = sed -e '/^\#/ d' -e '/^--/ d' -e t -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/\3/' -e t -e d keymaps.cfg
checkkeymapstags:	keymaps.cfg
	LC_ALL=C $(getkeymapstags) | sort | uniq -d | sed -e "s,^,[41m," -e "s,$$,[0m," | if grep .; then echo ERROR: duplicate tags in keymaps.cfg; false; else true; fi

# from:		Greek	GreekMonotonic	gr	(Y)
# generate:		{keymap_GreekMonotonic, "gr"},
keymapsk.t:	keymaps.cfg # mkinclud.mak
	LC_ALL=C sed -e '/^[-#]/ d' -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/	{keymap_\2, "\3"},/' -e t -e d keymaps.cfg > keymapsk.t

# from:		Greek	GreekMonotonic	gr	(Y)
# generate:		{"Greek", select_keymap_entry, "gr", keymapon, "Y"},
# from:		---- Group
# generate:		{"Group", separator, ""},
keymapsm.t:	keymaps.cfg # mkinclud.mak
	$(MAKE) -f mkinclud.mak checkkeymapstags
	LC_ALL=C sed -e '/^#/ d' -e 's/^--* *\(.*\) */	{"\1", separator, ""},/' -e t -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\)		*(*\([^)	 ]*\))*.*/	{"\1", select_keymap_entry, "\3", keymapon, "\4"},/' -e t -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\).*\([^ 	][^ 	]\).*/	{"\1", select_keymap_entry, "\3", keymapon},/' -e t -e d keymaps.cfg > keymapsm.t

# from:		Greek	GreekMonotonic	gr	(Y)
# generate:	#include "GreekMonotonic.h"
keymapsi.h:	keymaps.cfg # mkinclud.mak
	LC_ALL=C sed -e '/^[-#]/ d' -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/#include "\2.h"/' -e t -e d keymaps.cfg > keymapsi.h

# Character mapping configuration:

# check input method tag ("gr", ...) for uniqueness
checkcharmapstags:	charmaps.cfg mkchrcfg
	./mkchrcfg checktags

charmaps.t:	charmaps.cfg mkchrcfg
	$(MAKE) -f mkinclud.mak checkcharmapstags
	./mkchrcfg charmaps.t

charmaps.h:	charmaps.cfg mkchrcfg
	./mkchrcfg charmaps.h

charemen.t:	charmaps.cfg mkchrcfg
	./mkchrcfg charemen.t

charesub.t:	charmaps.cfg mkchrcfg
	./mkchrcfg charesub.t

# Mapping table locale (substring) -> charmap (encoding name)
# from:
#	ar_IN	UTF-8
#	ar	ISO-8859-6	MacArabic
# generate:
#		{"ar", "ISO-8859-6", "MacArabic"},
#		{"ar_IN", "UTF-8"},
locales.t:	locales.cfg # mkinclud.mak
	sed -e '/^#/ d' -e 's/\([^ 	][^ 	]*\)[ 	][ 	]*\([^ 	][^ 	]*\)[ 	]*\([^ 	]*\)/	{"\1", "\2", "\3"},/' -e 's/, ""//' locales.cfg | LC_ALL=C sort > locales.t

# Find supplements for locales.cfg:
localealiases:	/usr/share/locale/locale.alias locales.cfg
	sed -e "/^#/ d" -e "/8859-1$$/ d" -e "s,\([^ 	]*\)[ 	][ 	]*\([^ 	]*\),\1	\2," -e "s,	[^.]*\.,	," -e "s,	euc,	EUC-," /usr/share/locale/locale.alias | fgrep -v -x -f locales.cfg

# HTML character mnemonics:
zeichen.htm:
	$(WGET) http://de.selfhtml.org/html/referenz/zeichen.htm

mnemos.com: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent -

mnemos.ara: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Arabic

mnemos.cyr: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Cyrillic

mnemos.grk: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Greek

mnemos.heb: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Hebrew

mnemos.lat: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Latin

mnemos.www:	mnemos.tex # zeichen.htm
	./mkmnhtml zeichen.htm | fgrep -v -x -f mnemos.tex > mnemos.www
	./mnemos.check


#############################################################################
# generate tables for character encodings and keyboard mappings

# rules for non-GNU make:

# extract list of configured keyboard mappings from keymaps.cfg:
getKEYMAPS=`./mkkmlist`

# generate makefile to deal with variable list of dependencies,
# invoke it to generate cumulative keymaps file:
mkkeymaps:
	test -d keymaps || mkdir keymaps
	echo keymaps/_keymaps.h: keymaps.cfg $(getKEYMAPS) mkkmincl > keymaps/makefile
	echo "	./mkkmincl $(getKEYMAPS) > keymaps/_keymaps.h" >> keymaps/makefile
	$(MAKE) -f keymaps/makefile

# generate makefile to deal with variable list of targets,
# invoke it to generate and compile character mapping tables:
mkcharmaps:
	CC=$(CC) OPT="$(OPT)" ./mkmakchr > charmaps/makefile
	$(MAKE) -f charmaps/makefile


# rules for GNU make:

# KEYMAPS is extracted list of configured keyboard mappings from keymaps.cfg:
keymaps/_keymaps.h:	keymaps.cfg $(KEYMAPS) mkkmincl
	test -d keymaps || mkdir keymaps
	./mkkmincl $(KEYMAPS) > keymaps/_keymaps.h

# define generic rule to generate and compile character mapping tables:
#charmaps/%.o: charmaps/%.map charcode.h mkchrtab
#	CC=$(CC) OPT="$(OPT)" ./mkchrtab $<

# rather do it in 2 steps to facilitate generation with non-Unix make 
# after manual copying cross-generated .c files:
# generate character mapping tables:
charmaps/%.c: charmaps/%.map charcode.h mkchrtab
	CC=$(CC) OPT="$(OPT)" ./mkchrtab -S $<

# compile character mapping tables:
charmaps/%.o: charmaps/%.c
	$(CC) $(OPT) -I. -c $< -o charmaps/$*.o


#############################################################################
# Character input support tables:
MNEMOS=mnemos.???	# mnemos.sup, .gen, .rfc, .tex, .www
mnemos.h:	$(MNEMOS)
#	cat $(MNEMOS) > mnemos.h
	ls -1 $(MNEMOS) | sed -e 's,^,#include ",' -e 's,$$,",' > mnemos.h

# Documentation page for mnemonics (listing mined additional mnemos)
mnemodoc:	../doc/mnemodoc.html
../doc/mnemodoc.html:	mnemos.sup ../doc/mined.html mkmnemodoc
	./mkmnemodoc
	./mnemos.check


#############################################################################
# Location of online help file:
DHELP=-DRUNDIR=\"$(rundir)\" -DLRUNDIR=\"$(lrundir)\"

# About text:
VERSION=`sed -e 's,^[^0-9]*,,' -e 's,[^0-9][^0-9]*,.,g' -e q ../VERSION`
ABOUT=\"Mined $(VERSION) - http://mined.sourceforge.net/\"


#############################################################################
# Source compilation:
mined1.o:	mined1.c textfile.h encoding.h locales.t mined.h io.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) $(DHELP) -c mined1.c
textfile.o:	textfile.c textfile.h mined.h turbodir.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c textfile.c
textbuf.o:	textbuf.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c textbuf.c
justify.o:	justify.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c justify.c
edit.o:	edit.c mined.h io.h casespec.t casetabl.t softdot.t combin.t scripts.t charname.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c edit.c
pastebuf.o:	pastebuf.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c pastebuf.c
minedaux.o:	minedaux.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c minedaux.c
search.o:	search.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c search.c
mousemen.o:	mousemen.c mined.h io.h keymapsm.t charemen.t charesub.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c mousemen.c
output.o:	output.c colours.t mined.h io.h charprop.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c output.c
prompt.o:	prompt.c mined.h io.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c prompt.c
io.o:	io.c io.h mined.h $(MOUSELIB) dosvideo.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c io.c
iocurses.o:	io.c io.h mined.h termprop.h
	$(CC) $(CFLAGS) -DCURSES -DSETLOCALE $(PROTOFLAGS) -c io.c $(ICURSES) -o iocurses.o
keyboard.o:	keyboard.c mined.h termprop.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) $(KEYMAPSFLAGS) -c keyboard.c
keycurs.o:	keyboard.c mined.h termprop.h
	$(CC) $(CFLAGS) -DCURSES $(PROTOFLAGS) $(KEYMAPSFLAGS) -c keyboard.c $(ICURSES) -o keycurs.o
charcode.o:	charcode.c charcode.h charmaps.t charmaps.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c charcode.c
handescr.o:	handescr.c handescr.t
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c handescr.c
compose.o:	compose.c mined.h mnemos.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c compose.c
keymaps.o:	keymaps.c keymapsk.t $(KEYMAPSDEP)
	$(CC) $(CFLAGS) $(PROTOFLAGS) -Ikeymaps $(KEYMAPSFLAGS) -c keymaps.c
keydefs.o:	keydefs.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c keydefs.c
dispatch.o:	dispatch.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c dispatch.c
encoding.o:	encoding.c encoding.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c encoding.c
termprop.o:	termprop.c termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c termprop.c
width.o:	width.c width.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c width.c


#############################################################################
# Mined generation:
mined:	$(OBJS) $(SCREENOBJ)
	$(CC) $(OBJS) $(SCREENOBJ) $(SLIB) $(LINKOPTS) ${LDFLAGS} -o mined

minced:	$(OBJS) iocurses.o keycurs.o
	$(CC) $(OBJS) iocurses.o keycurs.o -lncursesw $(LDL) $(LINKOPTS) ${LDFLAGS} -o minced

#mined.exe:	$(OBJS) $(SCREENOBJ)
#	echo cygwin mined.exe needs to be generated before packaging
#	false


#############################################################################
# additional files, installation, cleanup

# Online help:
help:	../usrshare/help/mined.hlp

../usrshare/help/mined.hlp:	help/* mkhelp
	./mkhelp > ../usrshare/help/mined.hlp

# Manual page:
man:	../man/mined.1 ../man/uterm.1

../man/%.1:	../doc/%.html
	cd `/bin/pwd`/../man && $(MAKE)


# Install aliases; may be suppressed with make ...install makelinks=
makelinks=$(MAKE) -f mkinclud.mak links EXE=$(EXE)

links:	$(linkdir)/xmined $(linkdir)/minmacs$(EXE) $(linkdir)/mpico$(EXE) $(linkdir)/mstar$(EXE)

$(linkdir)/xmined:
	cd $(linkdir) && ln -s umined xmined

$(linkdir)/%:
	cd $(linkdir) && ln -s mined$(EXE) $*


# Install uterm and umined scripts;
# may be suppressed with make ...install installscript=echo
installscript=$(INSTALLBIN)
#installscript=echo not installing


# Installation:
# or installation to system-specific dir with make install root=...
install:	mined help man
	strip -p mined$(EXE) || true
	mkdir -p $(bindir)
	$(INSTALLBIN) mined$(EXE) $(bindir)
	$(installscript) ../usrshare/bin/uterm $(bindir)
	$(installscript) ../usrshare/bin/umined $(bindir)
	$(makelinks) linkdir=$(bindir)
	mkdir -p $(rundir)
	/bin/cp -pr ../usrshare/*/ $(rundir)
	mkdir -p $(mandir)/man1
	$(INSTALL) ../man/*.1 $(mandir)/man1
	if (ls $(mandir)/man1/*.gz && type gzip) > /dev/null 2>&1; then gzip -f $(mandir)/man1/mined.1; fi
	$(extrainstall)

# Local installation:
# or installation to system-specific local dir with make localinstall root=...
localinstall:	mined help man
	strip -p mined$(EXE) || true
	mkdir -p $(lbindir)
	$(INSTALLBIN) mined$(EXE) $(lbindir)
	$(installscript) ../usrshare/bin/uterm $(lbindir)
	$(installscript) ../usrshare/bin/umined $(lbindir)
	$(makelinks) linkdir=$(lbindir)
	mkdir -p $(lrundir)
	/bin/cp -pr ../usrshare/*/ $(lrundir)
	mkdir -p $(lmandir)/man1
	$(INSTALL) ../man/*.1 $(lmandir)/man1
	if (ls $(lmandir)/man1/*.gz && type gzip) > /dev/null 2>&1; then gzip -f $(lmandir)/man1/mined.1; fi
	$(extrainstall)

# /opt installation:
# or installation to system-specific opt subdir with make optinstall root=...
optinstall:	mined help man
	strip -p mined$(EXE) || true
	mkdir -p $(root)/opt/mined/bin
	$(INSTALLBIN) mined$(EXE) $(root)/opt/mined/bin
	$(installscript) ../usrshare/bin/uterm $(root)/opt/mined/bin
	$(installscript) ../usrshare/bin/umined $(root)/opt/mined/bin
	$(makelinks) linkdir=$(root)/opt/mined/bin
	mkdir -p $(root)/opt/mined/share
	/bin/cp -pr ../usrshare/*/ $(root)/opt/mined/share
	mkdir -p $(root)/opt/mined/man/man1
	$(INSTALL) ../man/*.1 $(root)/opt/mined/man/man1
	$(extrainstall)


# Cleanup after compilation:
clear:
	rm -f *.o charmaps/*.o colours.t keymaps?.t keymaps/_keymaps.h core
	rm -f charmaps/makefile keymaps/makefile
	rmdir keymaps || true

debianclean:
	rm -f mined semantic.cache ../debian/semantic.cache

clean:	clear debianclean


#############################################################################
# pre-generation of tables
generate:	keymaps1/Radical_Stroke.h

keymaps1/Radical_Stroke.h:	keymaps0/Radical_Stroke.h
	./mkkmincl keymaps0/Radical_Stroke.h > keymaps1/Radical_Stroke.h


#############################################################################
# development targets

# Cross-generation of charmaps files for MSDOS compilation
PCCHARMAPS=$(shell echo charmaps/*.map | sed -e "s, charmaps/cjk-[^ ]*.map,,g" )
PCCHARTABS=$(shell echo $(PCCHARMAPS) | sed -e "s,\.map,.c,g" )
#pc:	$(PCCHARTABS)	# dj complains "multiple target patterns" (???)
pc:
	./mkchrtab -S $(PCCHARMAPS)

# Tags file:
tags:	*.c *.h
	ctags -w *.c *.h

# Source update archive:
update:
	cd ../man && $(MAKE)
	zip -y mined-src-update *.h *.c makefile.* mk* doc/changes.html doc/mined.html man/*.1 -x handescr.t

# Check function valid_cjk:
validcjk:	validcjk.c termprop.o width.o charmaps/*.o
	$(CC) $(CFLAGS) -o validcjk validcjk.c termprop.o width.o charmaps/*.o

# VMS link script:
vms:
	echo '$$ define LNK$$LIBRARY   SYS$$LIBRARY:VAXCCURSE' > vms-link.new
	echo '$$ define LNK$$LIBRARY_1 SYS$$LIBRARY:VAXCRTL' >> vms-link.new
	echo $(SCREENOBJ) $(OBJS) | sed -e "s,\.o,,g" -e "s/ /,/g" -e "s,^,$$ link ," -e "s,$$, /executable=mined," >> vms-link.new
	cmp vms-link.com vms-link.new || mv -f vms-link.new vms-link.com
	rm -f vms-link.new

# Check correctness, consistency, uniqueness...
checkchar:	validcjk
	./validcjk
	./mnemos.check

checksrc:
	if egrep -e "^printf" -e "^#define debug" *.[hc]; then false; fi
	if sed -e "/-- test/,$$ b" -e d keymaps.cfg | egrep '^[^#]'; then false; else true; fi

check:	checksrc checkchar

# Check makefile function
ldl:
	echo $(ldl_libs)
	echo $(LDL)

checkmaps:
	echo all:	$(MAKEMAPS) mined
	echo mined:	$(OBJS) $(SCREENOBJ)


#############################################################################
# end
