/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "network.hh"
#include "exception.hh"
#include "application.hh"

UdpSocket::UdpSocket(const gchar* hostname, int port)
{
	address = gnet_inetaddr_new(hostname, port);
	socket = gnet_udp_socket_new();

	if (socket == NULL)
	{
		throw Exception(_("Failed to create a UDP socket"));
	}
}

UdpSocket::~UdpSocket()
{
	gnet_udp_socket_delete(socket);
}

void UdpSocket::write(const void* buffer, unsigned int length)
{
	if (gnet_udp_socket_send(socket, (const gchar*)buffer, length, address) != 0)
	{
		throw SystemException(_("Failed to write UDP packet"));
	}
}
