/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __DVB_DVR_H__
#define __DVB_DVR_H__

#include <sys/poll.h>
#include <fcntl.h>
#include "exception.hh"
#include "io.hh"

#define TS_PACKET_SIZE 188

class DvbDvr : public IO::Channel
{
private:
	static gint create_fd(const String& device_path);
	
public:
	DvbDvr(const String& device_path);

	gsize read(gchar* buffer, gsize count);
};

#endif
