/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "dvb_dvr.hh"
#include "application.hh"
#include <unistd.h>

DvbDvr::DvbDvr(const String& device_path) : IO::Channel(create_fd(device_path))
{
}

gint DvbDvr::create_fd(const String& device_path)
{
	gint result = open(device_path.c_str(), O_RDONLY|O_NONBLOCK);
	if (result < 0)
	{
		throw SystemException(_("Failed to open DVR device"));
	}
	
	return result;
}

gsize DvbDvr::read(gchar* buffer, gsize count)
{
	gint total_bytes_read = 0;
	
	if (count % TS_PACKET_SIZE)
	{
		throw Exception("Invalid buffer size");
	}

	while ((total_bytes_read+TS_PACKET_SIZE) < count)
	{
		if (poll(100))
		{
			total_bytes_read += ::read(get_fd(), buffer+total_bytes_read, TS_PACKET_SIZE);
		}
		else
		{
			usleep(1000);
		}
	}
	
	return (gsize)total_bytes_read;
}
