""" Abstract base class for all workbench actions. """


# Enthought library imports.
from enthought.pyface.action.api import Action
from enthought.traits.api import Instance
from enthought.envisage import get_application

# Local imports.
from workbench_window import WorkbenchWindow


class WorkbenchAction(Action):
    """ Abstract base class for all workbench actions. """

    #### 'WorkbenchAction' interface ##########################################
    
    # The resource manager.
    resource_manager = Instance('enthought.envisage.resource.ResourceManager')

    # The workbench window that the action is in.
    # FIXME: using the more obvious "Instance(WorkbenchWindow)" occasionally
    # causes type comparison problems in Traits.
    window = Instance('enthought.envisage.ui.workbench_window.WorkbenchWindow')

    ###########################################################################
    # Private interface.
    ###########################################################################

    #### Initializers #########################################################

    def _resource_manager_default(self):
        """ Initializes the 'resource_manager' trait. """

        resource_manager = get_application().service_registry.get_service(
            'enthought.envisage.resource.IResourceManager'
        )

        if resource_manager is None:
            raise SystemError("Resource manager service not found")
        
        return resource_manager
    
#### EOF ######################################################################
