""" The interactive Python shell plugin definition. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition
from enthought.traits.api import Any, Dict, List, Str

# Plugin definition imports.
from enthought.envisage.core.core_plugin_definition import ExtensionPoint
from enthought.envisage.core.core_plugin_definition import PluginDefinition
from enthought.envisage.ui.ui_plugin_definition import UIActions, UIViews, View


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.ui.python_shell"


###############################################################################
# Extension Points.
###############################################################################

class Namespace(ExtensionPoint):
    """ Bindings and commands to run when each shell view is created. """

    # Bindings.
    bindings = Dict(Str, Any)

    # Commands.
    commands = List(Str)

###############################################################################
# The plugin definition!
###############################################################################

PluginDefinition(
    # The plugin's globally unique identifier.
    id = ID,

    # The name of the class that implements the plugin.
    class_name = ID + ".PythonShellPlugin",

    # General information about the plugin.
    name          = "Interactive Python Shell Plugin",
    version       = "1.0.0",
    provider_name = "Enthought Inc",
    provider_url  = "www.enthought.com",
    enabled       = True,
    autostart     = False,
    
    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.ui"],

    # The extension points offered by this plugin.
    extension_points = [Namespace],
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [
        Namespace(
            commands = [
                'import os, sys',
                'import wx',
                'from enthought.envisage import application',
                'from enthought.traits.api import *',
                'from enthought.pyface.api import *',
                'from enthought.envisage.resource.ui import explore'
            ]
        ),

        UIViews(
            views = [
                View(
                    id         = ID + ".view.PythonShellView",
                    class_name = ID + ".view.PythonShellView",
                    name       = "Python",
                    image      = "images/python_view.png",
                    category   = ID + ".DefaultCategory",
                    position   = "bottom",
                )
            ]
        )
    ]
)

#### EOF ######################################################################
