""" The resource type for Python ints. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.traits.api import Int

# Local imports.
from int_node_type import IntNodeType


class IntResourceType(ObjectResourceType):
    """ The resource type for Python ints. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Int

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return IntNodeType(resource_type=self)

##### EOF #####################################################################
