""" Opens a resource properties view. """


# Enthought library imports.
from enthought.envisage.project import CookieAction, CookieManager

# Local imports.
from properties_cookie import PropertiesCookie


class PropertiesAction(CookieAction):
    """ Opens a resource properties view. """

    #### 'CookieAction' interface #############################################
    
    # The cookie required by this action.
    required_cookie = PropertiesCookie

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event = None):
        """ Performs the action. """                

        cm = CookieManager()
        
        for binding in self.window.selection:
            cookie = cm.get_cookie(self.required_cookie, binding.obj)
            if cookie is not None:
                cookie.open(self.window, binding)
            
        return

#### EOF ######################################################################
