""" Opens a resource. """


# Enthought library imports.
from enthought.envisage.project import CookieAction, CookieManager

# Local imports.
from open_cookie import OpenCookie


class OpenAction(CookieAction):
    """ Opens a resource. """

    #### 'CookieAction' interface #############################################
    
    # The cookie required by this action.
    required_cookie = OpenCookie

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event = None):
        """ Performs the action. """                

        cm = CookieManager()
        
        for binding in self.window.selection:
            cookie = cm.get_cookie(self.required_cookie, binding.obj)
            if cookie is not None:
                cookie.open(self.window, binding)
            
        return

#### EOF ######################################################################
