/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file MarkerValuePlotMethod.h
    \brief Definition of the Template class MarkerValuePlotMethod.
    
    Magics Team - ECMWF 2004
    
    Started: Thu 26-Aug-2004
    
    Changes:
    
*/

#ifndef MarkerValuePlotMethod_H
#define MarkerValuePlotMethod_H

#include "magics.h"

#include "ValuePlotMethod.h"
#include "MarkerValuePlotMethodAttributes.h"

namespace magics {

template <class P>
class MarkerValuePlotMethod: public ValuePlotMethod<P>, public MarkerValuePlotMethodAttributes {

public:
	MarkerValuePlotMethod() : marker_(0) {
       
	}
	virtual ~MarkerValuePlotMethod() {}
    virtual void set(const map<string, string>& map ) 
        { ValuePlotMethodAttributes::set(map);
          MarkerValuePlotMethodAttributes::set(map); }
    virtual void set(const XmlNode& node ) 
        { ValuePlotMethodAttributes::set(node);
          MarkerValuePlotMethodAttributes::set(node); }
    virtual ValuePlotMethod<P>* clone() const {
    	MarkerValuePlotMethod<P>* object = new MarkerValuePlotMethod<P>();
    	object->clone(*this);
    	return object;
    }
    
     virtual void clone(const MarkerValuePlotMethod<P>& from ) 
        { ValuePlotMethodAttributes::copy(from);
          MarkerValuePlotMethodAttributes::copy(from); }
    
    

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream& out) const {
         out << "MarkerValuePlotMethod[";
         MarkerValuePlotMethodAttributes::print(out);
         out << "]";
	 }
     
     virtual void add(const PaperPoint& xy) {        
          if (!marker_) {
            marker_ = new Symbol();
            marker_->setMarker(markerIndex_);
            marker_->setColour(*markerColour_);
            marker_->setHeight(markerHeight_);
            this->push_back(marker_); 
         }   
         marker_->push_back(xy);
    }
    Symbol* marker_;

private:
    //! Copy constructor - No copy allowed
	MarkerValuePlotMethod(const MarkerValuePlotMethod&);
    //! Overloaded << operator to copy - No copy allowed
	MarkerValuePlotMethod& operator=(const MarkerValuePlotMethod&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const MarkerValuePlotMethod<P>& p)
		{ p.print(s); return s; }

};

} // namespace magics


#endif
